/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.jdbc;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.tests.TpchTableResults;
import com.facebook.presto.tests.utils.JdbcDriverUtils;
import com.google.common.base.Strings;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.Requirements;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.Requires;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.MutableTableRequirement;
import io.prestodb.tempto.fulfillment.table.MutableTablesState;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestodb.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestodb.tempto.internal.convention.SqlResultDescriptor;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class JdbcTests
extends ProductTest {
    private static final Logger LOGGER = Logger.get(JdbcTests.class);
    private static final String TABLE_NAME = "nation_table_name";
    @Inject
    @Named(value="databases.presto.jdbc_url")
    private String prestoJdbcURL;
    @Inject
    @Named(value="databases.presto.jdbc_user")
    private String prestoJdbcUser;
    @Inject
    @Named(value="databases.presto.jdbc_password")
    private String prestoJdbcPassword;

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldExecuteQuery() throws SQLException {
        try (Statement statement = this.connection().createStatement();){
            QueryResult result = this.queryResult(statement, "select * from hive.default.nation");
            QueryAssert.assertThat((QueryResult)result).matches(TpchTableResults.PRESTO_NATION_RESULT);
        }
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableAndMutableNationTable.class})
    public void shouldInsertSelectQuery() throws SQLException {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasNoRows();
        try (Statement statement = this.connection().createStatement();){
            Assertions.assertThat((int)statement.executeUpdate("insert into " + tableNameInDatabase + " select * from nation")).isEqualTo(25);
        }
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldExecuteQueryWithSelectedCatalogAndSchema() throws SQLException {
        if (JdbcDriverUtils.usingTeradataJdbc4Driver(this.connection())) {
            LOGGER.warn("connection().setSchema() is not supported in JDBC 4");
        } else {
            this.connection().setCatalog("hive");
            this.connection().setSchema("default");
            try (Statement statement = this.connection().createStatement();){
                QueryResult result = this.queryResult(statement, "select * from nation");
                QueryAssert.assertThat((QueryResult)result).matches(TpchTableResults.PRESTO_NATION_RESULT);
            }
        }
    }

    @Test(groups={"jdbc"})
    public void shouldSetTimezone() throws SQLException {
        String timeZoneId = "Indian/Kerguelen";
        if (JdbcDriverUtils.usingPrestoJdbcDriver(this.connection())) {
            ((PrestoConnection)this.connection()).setTimeZoneId(timeZoneId);
            this.assertConnectionTimezone(this.connection(), timeZoneId);
        } else {
            String testTimeZone = "TimeZoneID=" + timeZoneId + ";";
            String prestoJdbcURLTestTimeZone = this.prestoJdbcURL.contains("TimeZoneID=") ? this.prestoJdbcURL.replaceFirst("TimeZoneID=[\\w/]*;", testTimeZone) : this.prestoJdbcURL + ";" + testTimeZone;
            Connection testConnection = DriverManager.getConnection(prestoJdbcURLTestTimeZone, this.prestoJdbcUser, this.prestoJdbcPassword);
            this.assertConnectionTimezone(testConnection, timeZoneId);
        }
    }

    private void assertConnectionTimezone(Connection connection, String timeZoneId) throws SQLException {
        try (Statement statement = connection.createStatement();){
            QueryResult result = this.queryResult(statement, "select current_timezone()");
            QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{timeZoneId})});
        }
    }

    @Test(groups={"jdbc"})
    public void shouldSetLocale() throws SQLException {
        if (JdbcDriverUtils.usingPrestoJdbcDriver(this.connection())) {
            ((PrestoConnection)this.connection()).setLocale(Locale.CHINESE);
            try (Statement statement = this.connection().createStatement();){
                QueryResult result = this.queryResult(statement, "SELECT date_format(TIMESTAMP '2001-01-09 09:04', '%M')");
                QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"\u4e00\u6708"})});
            }
        } else {
            LOGGER.warn("shouldSetLocale() only applies to PrestoJdbcDriver");
        }
    }

    @Test(groups={"jdbc"})
    public void shouldGetSchemas() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getSchemas("hive", null));
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", "hive"})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetTables() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getTables("hive", null, null, null));
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "default", "nation", "TABLE", null, null, null, null, null, null})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetColumns() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getColumns("hive", "default", "nation", null));
        if (JdbcDriverUtils.usingPrestoJdbcDriver(this.connection())) {
            QueryAssert.assertThat((QueryResult)result).matches(SqlResultDescriptor.sqlResultDescriptorForResource((String)"com/facebook/presto/tests/jdbc/get_nation_columns.result"));
        } else if (JdbcDriverUtils.usingTeradataJdbc4Driver(this.connection())) {
            QueryAssert.assertThat((QueryResult)result).matches(SqlResultDescriptor.sqlResultDescriptorForResource((String)"com/facebook/presto/tests/jdbc/get_nation_columns_simba4.result"));
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(this.connection())) {
            QueryAssert.assertThat((QueryResult)result).matches(SqlResultDescriptor.sqlResultDescriptorForResource((String)"com/facebook/presto/tests/jdbc/get_nation_columns_simba.result"));
        } else {
            throw new IllegalStateException();
        }
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetTableTypes() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getTableTypes());
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"VIEW"})});
    }

    @Test(groups={"jdbc", "simba_jdbc"})
    public void testSqlEscapeFunctions() {
        if (JdbcDriverUtils.usingTeradataJdbcDriver(this.connection())) {
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn char(40)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"("})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn convert('2016-10-10', SQL_DATE)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Date.valueOf("2016-10-10")})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn convert('1234.567', SQL_DECIMAL)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal(1235)})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn convert('123456', SQL_INTEGER)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{123456})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn convert('123abcd', SQL_VARBINARY)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"123abcd".getBytes()})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn dayofmonth(date '2016-10-20')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn dayofweek(date '2016-10-20')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn dayofyear(date '2016-10-20')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{294})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn ifnull({fn ifnull(null, null)}, '2')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"2"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn ifnull('abc', '2')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"abc"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn ifnull(null, '2')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"2"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn lcase('ABC def 123')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"abc def 123"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn left('abc def', 2)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ab"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn locate('d', 'abc def')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn log(5)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1.60943791243})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn right('abc def', 2)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ef"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn substring('abc def', 2)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"bc def"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn substring('abc def', 2, 2)}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"bc"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn timestampadd(SQL_TSI_DAY, 21, date '2001-01-01')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Date.valueOf("2001-01-22")})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn timestampdiff(SQL_TSI_DAY,date '2001-01-01',date '2002-01-01')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{365})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select {fn ucase('ABC def 123')}", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ABC DEF 123"})});
        } else {
            LOGGER.warn("testSqlEscapeFunctions() only applies to TeradataJdbcDriver");
        }
    }

    @Test(groups={"jdbc"})
    public void testSessionProperties() throws SQLException {
        String joinDistributionType = "join_distribution_type";
        String defaultValue = new FeaturesConfig().getJoinDistributionType().name();
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), "join_distribution_type")).isEqualTo((Object)defaultValue);
        JdbcDriverUtils.setSessionProperty(this.connection(), "join_distribution_type", "BROADCAST");
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), "join_distribution_type")).isEqualTo((Object)"BROADCAST");
        JdbcDriverUtils.resetSessionProperty(this.connection(), "join_distribution_type");
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), "join_distribution_type")).isEqualTo((Object)defaultValue);
    }

    @Test(groups={"jdbc"})
    public void testDeallocate() throws Exception {
        try (Connection connection = this.connection();){
            for (int i = 0; i < 200; ++i) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT '" + Strings.repeat((String)"a", (int)300) + "'");){
                    preparedStatement.executeQuery().close();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed at " + i, e);
                }
            }
        }
    }

    private QueryResult queryResult(Statement statement, String query) throws SQLException {
        return QueryResult.forResultSet((ResultSet)statement.executeQuery(query));
    }

    private DatabaseMetaData metaData() throws SQLException {
        return this.connection().getMetaData();
    }

    private Connection connection() {
        return QueryExecutor.defaultQueryExecutor().getConnection();
    }

    private static class ImmutableAndMutableNationTable
    implements RequirementsProvider {
        private ImmutableAndMutableNationTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION), TableRequirements.mutableTable((TableDefinition)TpchTableDefinitions.NATION, (String)JdbcTests.TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED)});
        }
    }
}

