/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.jdbc;

import com.facebook.presto.tests.ImmutableLdapObjectDefinitions;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.ldap.LdapObjectRequirement;
import io.prestodb.tempto.query.QueryResult;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.testng.Assert;

public abstract class LdapJdbcTests
extends ProductTest
implements RequirementsProvider {
    protected static final long TIMEOUT = 30000L;
    protected static final String NATION_SELECT_ALL_QUERY = "select * from tpch.tiny.nation";
    @Inject
    @Named(value="databases.presto.cli_ldap_truststore_path")
    protected String ldapTruststorePath;
    @Inject
    @Named(value="databases.presto.cli_ldap_truststore_password")
    protected String ldapTruststorePassword;
    @Inject
    @Named(value="databases.presto.cli_ldap_user_name")
    protected String ldapUserName;
    @Inject
    @Named(value="databases.presto.cli_ldap_user_password")
    protected String ldapUserPassword;
    @Inject
    @Named(value="databases.presto.cli_ldap_server_address")
    private String prestoServer;

    public Requirement getRequirements(Configuration configuration) {
        return new LdapObjectRequirement(Arrays.asList(ImmutableLdapObjectDefinitions.AMERICA_ORG, ImmutableLdapObjectDefinitions.ASIA_ORG, ImmutableLdapObjectDefinitions.DEFAULT_GROUP, ImmutableLdapObjectDefinitions.PARENT_GROUP, ImmutableLdapObjectDefinitions.CHILD_GROUP, ImmutableLdapObjectDefinitions.DEFAULT_GROUP_USER, ImmutableLdapObjectDefinitions.PARENT_GROUP_USER, ImmutableLdapObjectDefinitions.CHILD_GROUP_USER, ImmutableLdapObjectDefinitions.ORPHAN_USER));
    }

    protected void expectQueryToFail(String user, String password, String message) {
        try {
            this.executeLdapQuery(NATION_SELECT_ALL_QUERY, user, password);
            Assert.fail();
        }
        catch (SQLException exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)message);
        }
    }

    protected QueryResult executeLdapQuery(String query, String name, String password) throws SQLException {
        try (Connection connection = this.getLdapConnection(name, password);){
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(query);
            QueryResult queryResult = QueryResult.forResultSet((ResultSet)rs);
            return queryResult;
        }
    }

    private Connection getLdapConnection(String name, String password) throws SQLException {
        return DriverManager.getConnection(this.getLdapUrl(), name, password);
    }

    protected String prestoServer() {
        String prefix = "https://";
        Preconditions.checkState((boolean)this.prestoServer.startsWith(prefix), (String)"invalid server address: %s", (Object)this.prestoServer);
        return this.prestoServer.substring(prefix.length());
    }

    protected String getLdapUrl() {
        return String.format(this.getLdapUrlFormat(), this.prestoServer(), this.ldapTruststorePath, this.ldapTruststorePassword);
    }

    protected abstract String getLdapUrlFormat();
}

