/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.mysql;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.tests.utils.QueryExecutors;
import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requires;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import org.testng.annotations.Test;

public class CreateTableAsSelect
extends ProductTest {
    private static final String TABLE_NAME = "test.nation_tmp";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTable() {
        try {
            QueryExecutors.onMySql().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            Logger.get(((Object)((Object)this)).getClass()).warn((Throwable)e, "failed to drop table");
        }
    }

    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    @Test(groups={"jdbc", "mysql"})
    public void testCreateTableAsSelect() {
        QueryResult queryResult = QueryExecutor.query((String)String.format("CREATE TABLE mysql.%s AS SELECT * FROM nation", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
    }
}

