/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.querystats;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.tests.querystats.QueryStatsClient;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;

public class HttpQueryStatsClient
implements QueryStatsClient {
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final URI baseUri;

    public HttpQueryStatsClient(HttpClient httpClient, ObjectMapper objectMapper, URI baseUri) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.baseUri = baseUri;
    }

    @Override
    public Optional<QueryStats> getQueryStats(String queryId) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.baseUri).appendPath("/v1/query").appendPath(queryId).build();
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        return (Optional)this.httpClient.execute(request, (ResponseHandler)new GetQueryStatsResponseHandler());
    }

    private final class GetQueryStatsResponseHandler
    implements ResponseHandler<Optional<QueryStats>, RuntimeException> {
        private GetQueryStatsResponseHandler() {
        }

        public Optional<QueryStats> handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public Optional<QueryStats> handle(Request request, Response response) {
            if (response.getStatusCode() == HttpStatus.GONE.code()) {
                return Optional.empty();
            }
            if (response.getStatusCode() != HttpStatus.OK.code()) {
                throw new RuntimeException("unexpected error code " + response.getStatusCode() + "; reason=" + response.getStatusMessage());
            }
            try {
                JsonNode rootNode = HttpQueryStatsClient.this.objectMapper.readTree(response.getInputStream());
                JsonNode queryStatsNode = rootNode.get("queryStats");
                if (queryStatsNode == null) {
                    return Optional.empty();
                }
                QueryStats queryStats = (QueryStats)HttpQueryStatsClient.this.objectMapper.treeToValue((TreeNode)queryStatsNode, QueryStats.class);
                return Optional.of(queryStats);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

