/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.querystats;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.tests.querystats.HttpQueryStatsClient;
import com.facebook.presto.tests.querystats.QueryStatsClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Exposed;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.initialization.AutoModuleProvider;
import io.prestodb.tempto.initialization.SuiteModuleProvider;
import java.net.URI;
import javax.inject.Named;

@AutoModuleProvider
public class QueryStatsClientModuleProvider
implements SuiteModuleProvider {
    private static HttpQueryStatsClient httpQueryStatsClient;

    public Module getModule(final Configuration configuration) {
        return new PrivateModule(){

            protected void configure() {
                this.bind(ObjectMapper.class).toProvider(JsonObjectMapperProvider.class);
            }

            @Inject
            @Provides
            @Exposed
            QueryStatsClient getQueryStatsClient(ObjectMapper objectMapper, @Named(value="databases.presto.server_address") String serverAddress) {
                if (httpQueryStatsClient == null) {
                    HttpClientConfig httpClientConfig = new HttpClientConfig();
                    httpClientConfig.setKeyStorePath((String)configuration.getString("databases.presto.https_keystore_path").orElse(null));
                    httpClientConfig.setKeyStorePassword((String)configuration.getString("databases.presto.https_keystore_password").orElse(null));
                    httpQueryStatsClient = new HttpQueryStatsClient((HttpClient)new JettyHttpClient(httpClientConfig), objectMapper, URI.create(serverAddress));
                }
                return httpQueryStatsClient;
            }
        };
    }
}

