/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.sqlserver;

import com.facebook.presto.tests.sqlserver.SqlServerTpchTableDefinitions;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.query.QueryExecutor;
import org.testng.annotations.Test;

public class TestInvalidSelect
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)SqlServerTpchTableDefinitions.NATION);
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNonExistentTable() {
        String tableName = String.format("%s.%s.%s", "sqlserver", "dbo", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Table %s does not exist", tableName));
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNonExistentSchema() {
        String tableName = String.format("%s.%s.%s", "sqlserver", "does_not_exist", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Schema does_not_exist does not exist");
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNonExistentColumn() {
        String tableName = String.format("%s.%s.%s", "sqlserver", "dbo", SqlServerTpchTableDefinitions.NATION.getName());
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT bogus FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'bogus' cannot be resolved");
    }
}

