/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.sqlserver;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.tests.TpchTableResults;
import com.facebook.presto.tests.sqlserver.SqlServerDataTypesTableDefinition;
import com.facebook.presto.tests.sqlserver.SqlServerTpchTableDefinitions;
import com.facebook.presto.tests.utils.QueryExecutors;
import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.Requirements;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import org.testng.annotations.Test;

public class TestSelect
extends ProductTest
implements RequirementsProvider {
    private static final String CTAS_TABLE_NAME = "create_table_as_select";
    private static final String NATION_TABLE_NAME = String.format("%s.%s.%s", "sqlserver", "dbo", SqlServerTpchTableDefinitions.NATION.getName());
    private static final String CREATE_TABLE_AS_SELECT = String.format("%s.%s.%s", "sqlserver", "dbo", "create_table_as_select");
    private static final String ALL_TYPES_TABLE_NAME = String.format("%s.%s.%s", "sqlserver", "dbo", SqlServerDataTypesTableDefinition.SQLSERVER_ALL_TYPES.getName());

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)SqlServerTpchTableDefinitions.NATION), TableRequirements.immutableTable((TableDefinition)SqlServerDataTypesTableDefinition.SQLSERVER_ALL_TYPES)});
    }

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTables() {
        try {
            QueryExecutors.onPresto().executeQuery(String.format("DROP TABLE IF EXISTS %s", CREATE_TABLE_AS_SELECT), new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            Logger.get(((Object)((Object)this)).getClass()).warn((Throwable)e, "failed to drop table");
        }
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testSelectNation() {
        String sql = String.format("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM %s", NATION_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNationSelfInnerJoin() {
        String sql = String.format("SELECT n1.n_name, n2.n_regionkey FROM %s n1 JOIN %s n2 ON n1.n_nationkey = n2.n_regionkey WHERE n1.n_nationkey=3", NATION_TABLE_NAME, NATION_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3})});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNationJoinRegion() {
        String sql = String.format("SELECT c.n_name, t.name FROM %s c JOIN tpch.tiny.region t ON c.n_regionkey = t.regionkey WHERE c.n_nationkey=3", NATION_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", "AMERICA"})});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testAllDatatypes() {
        String sql = String.format("SELECT bi, si, i, ti, f, r, c, vc, te, nc, nvc, nt, d, dt, dt2, sdt, pf30, pf22 FROM %s", ALL_TYPES_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.BIGINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.TINYINT, JDBCType.DOUBLE, JDBCType.REAL, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.DATE, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.DOUBLE, JDBCType.REAL}).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Long.MIN_VALUE, (short)Short.MIN_VALUE, Integer.MIN_VALUE, (byte)-128, Double.MIN_VALUE, Float.valueOf("-3.40E+38"), "\u0000   ", "\u0000", "\u0000", "\u0000    ", "\u0000", "\u0000", Date.valueOf("0001-01-02"), Timestamp.valueOf("1753-01-01 00:00:00.000"), Timestamp.valueOf("0001-01-01 00:00:00.000"), Timestamp.valueOf("1900-01-01 00:00:00"), Double.MIN_VALUE, Float.valueOf("-3.40E+38")}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, (short)Short.MAX_VALUE, Integer.MAX_VALUE, (byte)127, Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), "abcd", "abcdef", "abcd", "abcde", "abcdefg", "abcd", Date.valueOf("9999-12-31"), Timestamp.valueOf("9999-12-31 23:59:59.997"), Timestamp.valueOf("9999-12-31 23:59:59.999"), Timestamp.valueOf("2079-06-06 00:00:00"), Double.valueOf("12345678912.3456756"), Float.valueOf("12345678.6557")}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null})});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testCreateTableAsSelect() {
        String sql = String.format("CREATE TABLE %s AS SELECT * FROM %s", CREATE_TABLE_AS_SELECT, NATION_TABLE_NAME);
        QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        sql = String.format("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM %s.%s.%s", "master", "dbo", CTAS_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onSqlServer().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }
}

