/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.teradata;

import com.facebook.presto.tests.utils.QueryExecutors;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.testng.annotations.Test;

public class TestTeradataFunctions
extends ProductTest {
    @Test(groups={"functions"})
    public void testIndex() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT index('high', 'ig')", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test(groups={"functions"})
    public void testChar2HexInt() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT char2hexint('\u0ca0\u76ca\u0ca0')", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"0CA076CA0CA0"})});
    }

    @Test(groups={"functions"})
    public void testToDate() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT to_date('1988/04/01', 'yyyy/mm/dd')", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Date.valueOf("1988-04-01")})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT to_date('1988/04/08', 'yyyy/mm/dd')", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Date.valueOf("1988-04-08")})});
    }

    @Test(groups={"functions"})
    public void testToTimestamp() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT to_timestamp('1988/04/08;02:03:04','yyyy/mm/dd;hh24:mi:ss')", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Timestamp.valueOf(LocalDateTime.of(1988, 4, 8, 2, 3, 4))})});
    }

    @Test(groups={"functions"})
    public void testToChar() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT to_char(TIMESTAMP '1988-04-08 14:15:16 +02:09','yyyy/mm/dd;hh24:mi:ss')", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1988/04/08;14:15:16"})});
    }
}

