/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.CompressionKind;
import com.facebook.hive.orc.OrcConf;
import com.facebook.hive.orc.OrcFile;
import com.facebook.hive.orc.OrcSerde;
import com.facebook.hive.orc.Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.serde2.ReaderWriterProfiler;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class OrcOutputFormat
extends FileOutputFormat<NullWritable, OrcSerde.OrcSerdeRow>
implements HiveOutputFormat<NullWritable, OrcSerde.OrcSerdeRow> {
    public RecordWriter<NullWritable, OrcSerde.OrcSerdeRow> getRecordWriter(FileSystem fileSystem, JobConf conf, String name, Progressable reporter) throws IOException {
        ReaderWriterProfiler.setProfilerOptions((Configuration)conf);
        return new OrcRecordWriter(fileSystem, new Path(name), (Configuration)conf, OrcConf.ConfVars.HIVE_ORC_STRIPE_SIZE.defaultLongVal, OrcConf.ConfVars.HIVE_ORC_COMPRESSION.defaultVal, OrcConf.ConfVars.HIVE_ORC_COMPRESSION_BLOCK_SIZE.defaultIntVal, OrcConf.ConfVars.HIVE_ORC_ROW_INDEX_STRIDE.defaultIntVal);
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf conf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable reporter) throws IOException {
        String compressionSizeStr;
        ReaderWriterProfiler.setProfilerOptions((Configuration)conf);
        String stripeSizeStr = tableProperties.getProperty("orc.stripe.size");
        long stripeSize = stripeSizeStr != null ? Long.valueOf(stripeSizeStr) : OrcConf.getLongVar((Configuration)conf, OrcConf.ConfVars.HIVE_ORC_STRIPE_SIZE);
        String compression = tableProperties.getProperty("orc.compress");
        if (compression == null) {
            compression = OrcConf.getVar((Configuration)conf, OrcConf.ConfVars.HIVE_ORC_COMPRESSION);
        }
        int compressionSize = (compressionSizeStr = tableProperties.getProperty("orc.compress.size")) != null ? Integer.valueOf(compressionSizeStr) : OrcConf.getIntVar((Configuration)conf, OrcConf.ConfVars.HIVE_ORC_COMPRESSION_BLOCK_SIZE);
        String rowIndexStrideStr = tableProperties.getProperty("orc.row.index.stride");
        int rowIndexStride = rowIndexStrideStr != null ? Integer.valueOf(rowIndexStrideStr) : OrcConf.getIntVar((Configuration)conf, OrcConf.ConfVars.HIVE_ORC_ROW_INDEX_STRIDE);
        String enableIndexesStr = tableProperties.getProperty("orc.create.index");
        boolean enableIndexes = enableIndexesStr != null ? Boolean.valueOf(enableIndexesStr) : OrcConf.getBoolVar((Configuration)conf, OrcConf.ConfVars.HIVE_ORC_CREATE_INDEX);
        if (!enableIndexes) {
            rowIndexStride = 0;
        }
        return new OrcRecordWriter(path.getFileSystem((Configuration)conf), path, (Configuration)conf, stripeSize, compression, compressionSize, rowIndexStride);
    }

    private static class OrcRecordWriter
    implements RecordWriter<NullWritable, OrcSerde.OrcSerdeRow>,
    StatsProvidingRecordWriter {
        private Writer writer = null;
        private final FileSystem fs;
        private final Path path;
        private final Configuration conf;
        private final long stripeSize;
        private final int compressionSize;
        private final CompressionKind compress;
        private final int rowIndexStride;
        private final SerDeStats stats;

        OrcRecordWriter(FileSystem fs, Path path, Configuration conf, long stripeSize, String compress, int compressionSize, int rowIndexStride) {
            this.fs = fs;
            this.path = path;
            this.conf = conf;
            this.stripeSize = stripeSize;
            this.compress = CompressionKind.valueOf(compress);
            this.compressionSize = compressionSize;
            this.rowIndexStride = rowIndexStride;
            this.stats = new SerDeStats();
        }

        public void write(NullWritable nullWritable, OrcSerde.OrcSerdeRow row) throws IOException {
            if (this.writer == null) {
                this.writer = OrcFile.createWriter(this.fs, this.path, this.conf, row.getInspector(), this.stripeSize, this.compress, this.compressionSize, this.rowIndexStride);
            }
            this.writer.addRow(row.getRow());
        }

        public void write(Writable row) throws IOException {
            OrcSerde.OrcSerdeRow serdeRow = (OrcSerde.OrcSerdeRow)row;
            if (this.writer == null) {
                this.writer = OrcFile.createWriter(this.fs, this.path, this.conf, serdeRow.getInspector(), this.stripeSize, this.compress, this.compressionSize, this.rowIndexStride);
            }
            this.writer.addRow(serdeRow.getRow());
        }

        public void close(Reporter reporter) throws IOException {
            this.close(true);
        }

        public void close(boolean b) throws IOException {
            if (this.writer == null) {
                StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(new ArrayList(), new ArrayList());
                this.writer = OrcFile.createWriter(this.fs, this.path, this.conf, (ObjectInspector)inspector, this.stripeSize, this.compress, this.compressionSize, this.rowIndexStride);
            }
            this.writer.close();
        }

        public SerDeStats getStats() {
            this.stats.setRawDataSize(this.writer.getRowRawDataSize());
            return this.stats;
        }
    }
}

