/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.lazy.OrcLazyRowObjectInspector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;

public class OrcSerde
implements SerDe {
    private final OrcSerdeRow row = new OrcSerdeRow();
    private ObjectInspector inspector = null;

    public void initialize(Configuration conf, Properties table) {
        String columnNameProperty = table.getProperty("columns");
        String columnTypeProperty = table.getProperty("columns.types");
        ArrayList<String> columnNames = new ArrayList<String>();
        if (columnNameProperty != null && columnNameProperty.length() > 0) {
            for (String name : columnNameProperty.split(",")) {
                columnNames.add(name);
            }
        }
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columnNames.size(); ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append("string");
            }
            columnTypeProperty = sb.toString();
        }
        ArrayList fieldTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        StructTypeInfo rootType = new StructTypeInfo();
        rootType.setAllStructFieldNames(columnNames);
        rootType.setAllStructFieldTypeInfos(fieldTypes);
        this.inspector = new OrcLazyRowObjectInspector(rootType);
    }

    public Class<? extends Writable> getSerializedClass() {
        return OrcSerdeRow.class;
    }

    public Writable serialize(Object realRow, ObjectInspector inspector) {
        this.row.realRow = realRow;
        this.row.inspector = inspector;
        return this.row;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        return writable;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    final class OrcSerdeRow
    implements Writable {
        private Object realRow;
        private ObjectInspector inspector;

        OrcSerdeRow() {
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("can't write the bundle");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("can't read the bundle");
        }

        ObjectInspector getInspector() {
            return this.inspector;
        }

        Object getRow() {
            return this.realRow;
        }
    }
}

