/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.com.google.common.collect.Multimap;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DynamicPartitionPruner;
import org.apache.hadoop.hive.ql.exec.tez.SplitGrouper;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.split.TezMapReduceSplitsGrouper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;

public class HiveSplitGenerator
extends InputInitializer {
    private static final Log LOG = LogFactory.getLog(HiveSplitGenerator.class);
    private final DynamicPartitionPruner pruner;
    private final Configuration conf;
    private final JobConf jobConf;
    private final MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto;
    private final MapWork work;
    private final SplitGrouper splitGrouper = new SplitGrouper();

    public HiveSplitGenerator(InputInitializerContext initializerContext) throws IOException, SerDeException {
        super(initializerContext);
        Preconditions.checkNotNull(initializerContext);
        this.userPayloadProto = MRInputHelpers.parseMRInputPayload((UserPayload)initializerContext.getInputUserPayload());
        this.conf = TezUtils.createConfFromByteString((ByteString)this.userPayloadProto.getConfigurationBytes());
        this.jobConf = new JobConf(this.conf);
        ShimLoader.getHadoopShims().getMergedCredentials(this.jobConf);
        this.work = Utilities.getMapWork((Configuration)this.jobConf);
        this.pruner = new DynamicPartitionPruner(initializerContext, this.work, this.jobConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> initialize() throws Exception {
        Utilities.setMapWork((Configuration)this.jobConf, this.work);
        try {
            boolean sendSerializedEvents = this.conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
            this.pruner.prune();
            InputSplitInfoMem inputSplitInfo = null;
            String realInputFormatName = this.conf.get("mapred.input.format.class");
            boolean groupingEnabled = this.userPayloadProto.getGroupingEnabled();
            if (!groupingEnabled) {
                throw new RuntimeException("HiveInputFormat does not support non-grouped splits, InputFormatName is: " + realInputFormatName);
            }
            InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)JavaUtils.loadClass(realInputFormatName), (Configuration)this.jobConf);
            int totalResource = this.getContext().getTotalAvailableResource().getMemory();
            int taskResource = this.getContext().getVertexTaskResource().getMemory();
            int availableSlots = totalResource / taskResource;
            float waves = this.conf.getFloat("tez.grouping.split-waves", TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_WAVES_DEFAULT);
            InputSplit[] splits = inputFormat.getSplits(this.jobConf, (int)((float)availableSlots * waves));
            LOG.info("Number of input splits: " + splits.length + ". " + availableSlots + " available slots, " + waves + " waves. Input format is: " + realInputFormatName);
            Multimap<Integer, InputSplit> groupedSplits = this.splitGrouper.generateGroupedSplits(this.jobConf, this.conf, splits, waves, availableSlots);
            InputSplit[] flatSplits = groupedSplits.values().toArray(new InputSplit[0]);
            LOG.info("Number of grouped splits: " + flatSplits.length);
            List<TaskLocationHint> locationHints = this.splitGrouper.createTaskLocationHints(flatSplits);
            inputSplitInfo = new InputSplitInfoMem(flatSplits, locationHints, flatSplits.length, null, (Configuration)this.jobConf);
            List<Event> list = this.createEventList(sendSerializedEvents, inputSplitInfo);
            return list;
        }
        finally {
            Utilities.clearWork((Configuration)this.jobConf);
        }
    }

    private List<Event> createEventList(boolean sendSerializedEvents, InputSplitInfoMem inputSplitInfo) {
        ArrayList<Event> events = Lists.newArrayListWithCapacity(inputSplitInfo.getNumTasks() + 1);
        InputConfigureVertexTasksEvent configureVertexEvent = InputConfigureVertexTasksEvent.create((int)inputSplitInfo.getNumTasks(), (VertexLocationHint)VertexLocationHint.create((List)inputSplitInfo.getTaskLocationHints()), (InputSpecUpdate)InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate());
        events.add((Event)configureVertexEvent);
        if (sendSerializedEvents) {
            MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
            int count = 0;
            for (MRRuntimeProtos.MRSplitProto mrSplit : splitsProto.getSplitsList()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)count++, (ByteBuffer)mrSplit.toByteString().asReadOnlyByteBuffer());
                events.add((Event)diEvent);
            }
        } else {
            int count = 0;
            for (InputSplit split : inputSplitInfo.getOldFormatSplits()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                events.add((Event)diEvent);
            }
        }
        return events;
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        this.pruner.processVertex(stateUpdate.getVertexName());
    }

    public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        for (InputInitializerEvent e : events) {
            this.pruner.addEvent(e);
        }
    }
}

