/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRowNoNulls;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class VectorMapJoinLeftSemiMultiKeyOperator
extends VectorMapJoinLeftSemiGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VectorMapJoinInnerBigOnlyLongOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinLeftSemiMultiKeyOperator.class.getName();
    private transient VectorMapJoinBytesHashSet hashSet;
    private transient VectorSerializeRowNoNulls keyVectorSerializeWriteNoNulls;
    private transient ByteStream.Output currentKeyOutput;
    private transient ByteStream.Output saveKeyOutput;

    public VectorMapJoinLeftSemiMultiKeyOperator() {
    }

    public VectorMapJoinLeftSemiMultiKeyOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            boolean allKeyInputColumnsRepeating;
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.keyVectorSerializeWriteNoNulls = new VectorSerializeRowNoNulls(new BinarySortableSerializeWrite(this.bigTableKeyColumnMap.length));
                this.keyVectorSerializeWriteNoNulls.init(this.bigTableKeyTypeNames, this.bigTableKeyColumnMap);
                this.currentKeyOutput = new ByteStream.Output();
                this.saveKeyOutput = new ByteStream.Output();
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashSet = (VectorMapJoinBytesHashSet)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            int numSel = 0;
            if (this.bigTableKeyColumnMap.length == 0) {
                allKeyInputColumnsRepeating = false;
            } else {
                allKeyInputColumnsRepeating = true;
                for (int i = 0; i < this.bigTableKeyColumnMap.length; ++i) {
                    if (batch.cols[this.bigTableKeyColumnMap[i]].isRepeating) continue;
                    allKeyInputColumnsRepeating = false;
                    break;
                }
            }
            if (allKeyInputColumnsRepeating) {
                this.keyVectorSerializeWriteNoNulls.setOutput(this.currentKeyOutput);
                this.keyVectorSerializeWriteNoNulls.serializeWriteNoNulls(batch, 0);
                byte[] keyBytes = this.currentKeyOutput.getData();
                int keyLength = this.currentKeyOutput.getLength();
                JoinUtil.JoinResult joinResult = this.hashSet.contains(keyBytes, 0, keyLength, this.hashSetResults[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                numSel = this.finishLeftSemiRepeated(batch, joinResult, this.hashSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashSetResultCount = 0;
                int allMatchCount = 0;
                int spillCount = 0;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block22: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    this.keyVectorSerializeWriteNoNulls.setOutput(this.currentKeyOutput);
                    this.keyVectorSerializeWriteNoNulls.serializeWriteNoNulls(batch, batchIndex);
                    if (!haveSaveKey || !this.saveKeyOutput.arraysEquals(this.currentKeyOutput)) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    break;
                                }
                                case SPILL: {
                                    ++hashSetResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        ByteStream.Output temp = this.saveKeyOutput;
                        this.saveKeyOutput = this.currentKeyOutput;
                        this.currentKeyOutput = temp;
                        byte[] keyBytes = this.saveKeyOutput.getData();
                        int keyLength = this.saveKeyOutput.getLength();
                        saveJoinResult = this.hashSet.contains(keyBytes, 0, keyLength, this.hashSetResults[hashSetResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block22;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                            ++spillCount;
                            continue block22;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            break;
                        }
                        case SPILL: {
                            ++hashSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatchs " + VectorMapJoinLeftSemiMultiKeyOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " spills " + VectorMapJoinLeftSemiMultiKeyOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinLeftSemiMultiKeyOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashSetResults, 0, hashSetResultCount)));
                }
                numSel = this.finishLeftSemi(batch, this.allMatchs, allMatchCount, this.spills, this.spillHashMapResultIndices, spillCount, this.hashSetResults);
            }
            batch.selectedInUse = true;
            batch.size = numSel;
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

