/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastKeyStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastValueStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.io.BytesWritable;

public abstract class VectorMapJoinFastBytesHashMap
extends VectorMapJoinFastBytesHashTable
implements VectorMapJoinBytesHashMap {
    private static final Log LOG = LogFactory.getLog(VectorMapJoinFastBytesHashMap.class);
    private VectorMapJoinFastValueStore valueStore;

    @Override
    public VectorMapJoinHashMapResult createHashMapResult() {
        return new VectorMapJoinFastValueStore.HashMapResult();
    }

    @Override
    public void assignSlot(int slot, byte[] keyBytes, int keyStart, int keyLength, long hashCode, boolean isNewKey, BytesWritable currentValue) {
        byte[] valueBytes = currentValue.getBytes();
        int valueLength = currentValue.getLength();
        int tripleIndex = 3 * slot;
        if (isNewKey) {
            this.slotTriples[tripleIndex] = this.keyStore.add(keyBytes, keyStart, keyLength);
            this.slotTriples[tripleIndex + 1] = hashCode;
            this.slotTriples[tripleIndex + 2] = this.valueStore.addFirst(valueBytes, 0, valueLength);
            ++this.keysAssigned;
        } else {
            this.slotTriples[tripleIndex + 2] = this.valueStore.addMore(this.slotTriples[tripleIndex + 2], valueBytes, 0, valueLength);
        }
    }

    @Override
    public JoinUtil.JoinResult lookup(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMapResult hashMapResult) {
        JoinUtil.JoinResult joinResult;
        VectorMapJoinFastValueStore.HashMapResult optimizedHashMapResult = (VectorMapJoinFastValueStore.HashMapResult)hashMapResult;
        optimizedHashMapResult.forget();
        long hashCode = VectorMapJoinFastBytesHashUtil.hashKey(keyBytes, keyStart, keyLength);
        long valueRefWord = this.findReadSlot(keyBytes, keyStart, keyLength, hashCode);
        if (valueRefWord == -1L) {
            joinResult = JoinUtil.JoinResult.NOMATCH;
        } else {
            optimizedHashMapResult.set(this.valueStore, valueRefWord);
            joinResult = JoinUtil.JoinResult.MATCH;
        }
        optimizedHashMapResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastBytesHashMap(int initialCapacity, float loadFactor, int writeBuffersSize) {
        super(initialCapacity, loadFactor, writeBuffersSize);
        this.valueStore = new VectorMapJoinFastValueStore(writeBuffersSize);
        this.keyStore = new VectorMapJoinFastKeyStore(this.valueStore.writeBuffers());
    }
}

