/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationValidator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.Operation2Privilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.RequiredPrivileges;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLAuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAccessControllerWrapper;

public class SQLStdHiveAuthorizationValidator
implements HiveAuthorizationValidator {
    private final HiveMetastoreClientFactory metastoreClientFactory;
    private final HiveConf conf;
    private final HiveAuthenticationProvider authenticator;
    private final SQLStdHiveAccessControllerWrapper privController;
    private final HiveAuthzSessionContext ctx;
    public static final Log LOG = LogFactory.getLog(SQLStdHiveAuthorizationValidator.class);

    public SQLStdHiveAuthorizationValidator(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator, SQLStdHiveAccessControllerWrapper privilegeManager, HiveAuthzSessionContext ctx) throws HiveAuthzPluginException {
        this.metastoreClientFactory = metastoreClientFactory;
        this.conf = conf;
        this.authenticator = authenticator;
        this.privController = privilegeManager;
        this.ctx = SQLAuthorizationUtils.applyTestSettings(ctx, conf);
        this.assertHiveCliAuthDisabled(conf);
    }

    private void assertHiveCliAuthDisabled(HiveConf conf) throws HiveAuthzPluginException {
        if (this.ctx.getClientType() == HiveAuthzSessionContext.CLIENT_TYPE.HIVECLI && conf.getBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            throw new HiveAuthzPluginException("SQL standards based authorization should not be enabled from hive cliInstead the use of storage based authorization in hive metastore is reccomended. Set " + HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED.varname + "=false to disable authz within cli");
        }
    }

    @Override
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            String msg = "Checking privileges for operation " + (Object)((Object)hiveOpType) + " by user " + this.authenticator.getUserName() + " on " + " input objects " + inputHObjs + " and output objects " + outputHObjs + ". Context Info: " + context;
            LOG.debug(msg);
        }
        String userName = this.authenticator.getUserName();
        IMetaStoreClient metastoreClient = this.metastoreClientFactory.getHiveMetastoreClient();
        ArrayList<String> deniedMessages = new ArrayList<String>();
        this.checkPrivileges(hiveOpType, inputHObjs, metastoreClient, userName, Operation2Privilege.IOType.INPUT, deniedMessages);
        this.checkPrivileges(hiveOpType, outputHObjs, metastoreClient, userName, Operation2Privilege.IOType.OUTPUT, deniedMessages);
        SQLAuthorizationUtils.assertNoDeniedPermissions(new HivePrincipal(userName, HivePrincipal.HivePrincipalType.USER), hiveOpType, deniedMessages);
    }

    private void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> hiveObjects, IMetaStoreClient metastoreClient, String userName, Operation2Privilege.IOType ioType, List<String> deniedMessages) throws HiveAuthzPluginException, HiveAccessControlException {
        if (hiveObjects == null) {
            return;
        }
        block5: for (HivePrivilegeObject hiveObj : hiveObjects) {
            RequiredPrivileges requiredPrivs = Operation2Privilege.getRequiredPrivs(hiveOpType, hiveObj, ioType);
            if (requiredPrivs.getRequiredPrivilegeSet().isEmpty()) continue;
            RequiredPrivileges availPrivs = new RequiredPrivileges();
            switch (hiveObj.getType()) {
                case LOCAL_URI: 
                case DFS_URI: {
                    availPrivs = SQLAuthorizationUtils.getPrivilegesFromFS(new Path(hiveObj.getObjectName()), this.conf, userName);
                    break;
                }
                case PARTITION: {
                    continue block5;
                }
                case COMMAND_PARAMS: 
                case FUNCTION: {
                    if (!this.privController.isUserAdmin()) break;
                    availPrivs.addPrivilege(SQLPrivTypeGrant.ADMIN_PRIV);
                    break;
                }
                default: {
                    availPrivs = SQLAuthorizationUtils.getPrivilegesFromMetaStore(metastoreClient, userName, hiveObj, this.privController.getCurrentRoleNames(), this.privController.isUserAdmin());
                }
            }
            Collection<SQLPrivTypeGrant> missingPriv = requiredPrivs.findMissingPrivs(availPrivs);
            SQLAuthorizationUtils.addMissingPrivMsg(missingPriv, hiveObj, deniedMessages);
        }
    }

    @Override
    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> listObjs, HiveAuthzContext context) {
        return listObjs;
    }
}

