/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.base.Preconditions;
import io.airlift.slice.XxHash64;

public class RaptorBucketFunction
implements BucketFunction {
    private final int bucketCount;

    public RaptorBucketFunction(int bucketCount) {
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be at least one");
        this.bucketCount = bucketCount;
    }

    public int getBucket(Page page, int position) {
        long hash = 0L;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Block block = page.getBlock(i);
            long value = BigintType.BIGINT.getLong(block, position);
            hash = hash * 31L + XxHash64.hash((long)value);
        }
        int value = (int)(hash & Integer.MAX_VALUE);
        return value % this.bucketCount;
    }
}

