/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class RaptorColumnHandle
implements ColumnHandle {
    public static final String SAMPLE_WEIGHT_COLUMN_NAME = "$sample_weight";
    private static final long SHARD_ROW_ID_COLUMN_ID = -1L;
    private static final String SHARD_ROW_ID_COLUMN_NAME = "$shard_row_id";
    public static final long SHARD_UUID_COLUMN_ID = -2L;
    public static final String SHARD_UUID_COLUMN_NAME = "$shard_uuid";
    public static final Type SHARD_UUID_COLUMN_TYPE = VarcharType.createVarcharType((int)36);
    public static final long BUCKET_NUMBER_COLUMN_ID = -3L;
    public static final String BUCKET_NUMBER_COLUMN_NAME = "$bucket_number";
    private final String connectorId;
    private final String columnName;
    private final long columnId;
    private final Type columnType;

    @JsonCreator
    public RaptorColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnId") long columnId, @JsonProperty(value="columnType") Type columnType) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnId = columnId;
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public long getColumnId() {
        return this.columnId;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return this.connectorId + ":" + this.columnName + ":" + this.columnId + ":" + this.columnType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RaptorColumnHandle other = (RaptorColumnHandle)obj;
        return Objects.equals(this.columnId, other.columnId);
    }

    public int hashCode() {
        return Objects.hash(this.columnId);
    }

    public boolean isShardRowId() {
        return RaptorColumnHandle.isShardRowIdColumn(this.columnId);
    }

    public boolean isShardUuid() {
        return RaptorColumnHandle.isShardUuidColumn(this.columnId);
    }

    public boolean isBucketNumber() {
        return RaptorColumnHandle.isBucketNumberColumn(this.columnId);
    }

    public static boolean isShardRowIdColumn(long columnId) {
        return columnId == -1L;
    }

    public static RaptorColumnHandle shardRowIdHandle(String connectorId) {
        return new RaptorColumnHandle(connectorId, SHARD_ROW_ID_COLUMN_NAME, -1L, (Type)BigintType.BIGINT);
    }

    public static boolean isShardUuidColumn(long columnId) {
        return columnId == -2L;
    }

    public static RaptorColumnHandle shardUuidColumnHandle(String connectorId) {
        return new RaptorColumnHandle(connectorId, SHARD_UUID_COLUMN_NAME, -2L, SHARD_UUID_COLUMN_TYPE);
    }

    public static boolean isBucketNumberColumn(long columnId) {
        return columnId == -3L;
    }

    public static RaptorColumnHandle bucketNumberColumnHandle(String connectorId) {
        return new RaptorColumnHandle(connectorId, BUCKET_NUMBER_COLUMN_NAME, -3L, (Type)IntegerType.INTEGER);
    }

    public static boolean isHiddenColumn(long columnId) {
        return columnId < 0L;
    }
}

