/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorConnector;
import com.facebook.presto.raptor.RaptorHandleResolver;
import com.facebook.presto.raptor.RaptorModule;
import com.facebook.presto.raptor.backup.BackupModule;
import com.facebook.presto.raptor.storage.StorageModule;
import com.facebook.presto.raptor.util.CurrentNodeId;
import com.facebook.presto.raptor.util.RebindSafeMBeanServer;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Objects;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class RaptorConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Module metadataModule;
    private final Map<String, Module> backupProviders;
    private final Map<String, String> optionalConfig;
    private final NodeManager nodeManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final TypeManager typeManager;
    private final PageSorter pageSorter;

    public RaptorConnectorFactory(String name, Module metadataModule, Map<String, Module> backupProviders, Map<String, String> optionalConfig, NodeManager nodeManager, PageSorter pageSorter, BlockEncodingSerde blockEncodingSerde, TypeManager typeManager) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metadataModule = Objects.requireNonNull(metadataModule, "metadataModule is null");
        this.backupProviders = ImmutableMap.copyOf(Objects.requireNonNull(backupProviders, "backupProviders is null"));
        this.optionalConfig = Objects.requireNonNull(optionalConfig, "optionalConfig is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new RaptorHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MBeanModule(), binder -> {
                CurrentNodeId currentNodeId = new CurrentNodeId(this.nodeManager.getCurrentNode().getNodeIdentifier());
                RebindSafeMBeanServer mbeanServer = new RebindSafeMBeanServer(ManagementFactory.getPlatformMBeanServer());
                binder.bind(MBeanServer.class).toInstance((Object)mbeanServer);
                binder.bind(CurrentNodeId.class).toInstance((Object)currentNodeId);
                binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
                binder.bind(PageSorter.class).toInstance((Object)this.pageSorter);
                binder.bind(BlockEncodingSerde.class).toInstance((Object)this.blockEncodingSerde);
                binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
            }, this.metadataModule, new BackupModule(this.backupProviders), new StorageModule(connectorId), new RaptorModule(connectorId)});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            return (Connector)injector.getInstance(RaptorConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

