/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorConnectorId;
import com.facebook.presto.raptor.RaptorMetadata;
import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.ShardDelta;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.metadata.ShardManager;
import io.airlift.json.JsonCodec;
import java.util.Objects;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class RaptorMetadataFactory {
    private final String connectorId;
    private final IDBI dbi;
    private final ShardManager shardManager;
    private final JsonCodec<ShardInfo> shardInfoCodec;
    private final JsonCodec<ShardDelta> shardDeltaCodec;

    @Inject
    public RaptorMetadataFactory(RaptorConnectorId connectorId, @ForMetadata IDBI dbi, ShardManager shardManager, JsonCodec<ShardInfo> shardInfoCodec, JsonCodec<ShardDelta> shardDeltaCodec) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.dbi = Objects.requireNonNull(dbi, "dbi is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.shardInfoCodec = Objects.requireNonNull(shardInfoCodec, "shardInfoCodec is null");
        this.shardDeltaCodec = Objects.requireNonNull(shardDeltaCodec, "shardDeltaCodec is null");
    }

    public RaptorMetadata create() {
        return new RaptorMetadata(this.connectorId, this.dbi, this.shardManager, this.shardInfoCodec, this.shardDeltaCodec);
    }
}

