/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorInsertTableHandle;
import com.facebook.presto.raptor.RaptorOutputTableHandle;
import com.facebook.presto.raptor.RaptorPageSink;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.util.Types;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RaptorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final StorageManager storageManager;
    private final PageSorter pageSorter;
    private final JsonCodec<ShardInfo> shardInfoCodec;
    private final DataSize maxBufferSize;

    @Inject
    public RaptorPageSinkProvider(StorageManager storageManager, PageSorter pageSorter, JsonCodec<ShardInfo> shardInfoCodec, StorageManagerConfig config) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.shardInfoCodec = Objects.requireNonNull(shardInfoCodec, "shardInfoCodec is null");
        this.maxBufferSize = config.getMaxBufferSize();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        RaptorOutputTableHandle handle = Types.checkType(tableHandle, RaptorOutputTableHandle.class, "tableHandle");
        return new RaptorPageSink(this.pageSorter, this.storageManager, this.shardInfoCodec, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), handle.getSampleWeightColumnHandle().map(RaptorColumnHandle::getColumnId), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), this.maxBufferSize);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        RaptorInsertTableHandle handle = Types.checkType(tableHandle, RaptorInsertTableHandle.class, "tableHandle");
        return new RaptorPageSink(this.pageSorter, this.storageManager, this.shardInfoCodec, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), Optional.empty(), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), this.maxBufferSize);
    }

    private static List<Long> toColumnIds(List<RaptorColumnHandle> columnHandles) {
        return columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
    }
}

