/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.PluginInfo;
import com.facebook.presto.raptor.RaptorConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.inject.Inject;

public class RaptorPlugin
implements Plugin {
    private final String name;
    private final Module metadataModule;
    private final Map<String, Module> backupProviders;
    private Map<String, String> optionalConfig = ImmutableMap.of();
    private NodeManager nodeManager;
    private PageSorter pageSorter;
    private BlockEncodingSerde blockEncodingSerde;
    private TypeManager typeManager;

    public RaptorPlugin() {
        this(RaptorPlugin.getPluginInfo());
    }

    private RaptorPlugin(PluginInfo info) {
        this(info.getName(), info.getMetadataModule(), info.getBackupProviders());
    }

    public RaptorPlugin(String name, Module metadataModule, Map<String, Module> backupProviders) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metadataModule = Objects.requireNonNull(metadataModule, "metadataModule is null");
        this.backupProviders = ImmutableMap.copyOf(Objects.requireNonNull(backupProviders, "backupProviders is null"));
    }

    public void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf(Objects.requireNonNull(optionalConfig, "optionalConfig is null"));
    }

    @Inject
    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    @Inject
    public void setPageSorter(PageSorter pageSorter) {
        this.pageSorter = pageSorter;
    }

    @Inject
    public void setBlockEncodingSerde(BlockEncodingSerde blockEncodingSerde) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    @Inject
    public void setTypeManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public <T> List<T> getServices(Class<T> type) {
        Preconditions.checkState((this.nodeManager != null ? 1 : 0) != 0, (Object)"NodeManager has not been set");
        Preconditions.checkState((this.blockEncodingSerde != null ? 1 : 0) != 0, (Object)"BlockEncodingSerde has not been set");
        Preconditions.checkState((this.typeManager != null ? 1 : 0) != 0, (Object)"TypeManager has not been set");
        if (type == ConnectorFactory.class) {
            return ImmutableList.of(type.cast(new RaptorConnectorFactory(this.name, this.metadataModule, this.backupProviders, this.optionalConfig, this.nodeManager, this.pageSorter, this.blockEncodingSerde, this.typeManager)));
        }
        return ImmutableList.of();
    }

    private static PluginInfo getPluginInfo() {
        ClassLoader classLoader = RaptorPlugin.class.getClassLoader();
        ServiceLoader<PluginInfo> loader = ServiceLoader.load(PluginInfo.class, classLoader);
        ImmutableList list = ImmutableList.copyOf(loader);
        return list.isEmpty() ? new PluginInfo() : (PluginInfo)Iterables.getOnlyElement((Iterable)list);
    }
}

