/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public class RaptorSessionProperties {
    private static final String EXTERNAL_BATCH_ID = "external_batch_id";
    private static final String READER_MAX_MERGE_DISTANCE = "reader_max_merge_distance";
    private static final String READER_MAX_READ_SIZE = "reader_max_read_size";
    private static final String READER_STREAM_BUFFER_SIZE = "reader_stream_buffer_size";
    private static final String ONE_SPLIT_PER_BUCKET_THRESHOLD = "one_split_per_bucket_threshold";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public RaptorSessionProperties(StorageManagerConfig config) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringSessionProperty((String)EXTERNAL_BATCH_ID, (String)"Two-phase commit batch ID", null, (boolean)true), RaptorSessionProperties.dataSizeSessionProperty(READER_MAX_MERGE_DISTANCE, "Reader: Maximum size of gap between two reads to merge into a single read", config.getOrcMaxMergeDistance(), false), RaptorSessionProperties.dataSizeSessionProperty(READER_MAX_READ_SIZE, "Reader: Maximum size of a single read", config.getOrcMaxReadSize(), false), RaptorSessionProperties.dataSizeSessionProperty(READER_STREAM_BUFFER_SIZE, "Reader: Size of buffer for streaming reads", config.getOrcStreamBufferSize(), false), (Object)PropertyMetadata.integerSessionProperty((String)ONE_SPLIT_PER_BUCKET_THRESHOLD, (String)"Experimental: Maximum bucket count at which to produce multiple splits per bucket", (Integer)config.getOneSplitPerBucketThreshold(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static Optional<String> getExternalBatchId(ConnectorSession session) {
        return Optional.ofNullable(session.getProperty(EXTERNAL_BATCH_ID, String.class));
    }

    public static DataSize getReaderMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(READER_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getReaderMaxReadSize(ConnectorSession session) {
        return (DataSize)session.getProperty(READER_MAX_READ_SIZE, DataSize.class);
    }

    public static DataSize getReaderStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(READER_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static int getOneSplitPerBucketThreshold(ConnectorSession session) {
        return (Integer)session.getProperty(ONE_SPLIT_PER_BUCKET_THRESHOLD, Integer.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)), DataSize::toString);
    }
}

