/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.backup;

import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.raptor.backup.FileBackupConfig;
import com.facebook.presto.raptor.storage.FileStorageService;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class FileBackupStore
implements BackupStore {
    private final File baseDir;

    @Inject
    public FileBackupStore(FileBackupConfig config) {
        this(config.getBackupDirectory());
    }

    public FileBackupStore(File baseDir) {
        this.baseDir = Objects.requireNonNull(baseDir, "baseDir is null");
    }

    @PostConstruct
    public void start() {
        FileBackupStore.createDirectories(this.baseDir);
    }

    @Override
    public void backupShard(UUID uuid, File source) {
        File backupFile = this.getBackupFile(uuid);
        FileBackupStore.createDirectories(backupFile.getParentFile());
        try {
            FileBackupStore.copyFile(source, backupFile);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to create backup shard file", (Throwable)e);
        }
    }

    @Override
    public void restoreShard(UUID uuid, File target) {
        try {
            FileBackupStore.copyFile(this.getBackupFile(uuid), target);
        }
        catch (FileNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_NOT_FOUND, "Backup shard not found: " + uuid, (Throwable)e);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to copy backup shard: " + uuid, (Throwable)e);
        }
    }

    @Override
    public boolean deleteShard(UUID uuid) {
        try {
            return Files.deleteIfExists(this.getBackupFile(uuid).toPath());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to delete backup shard: " + uuid, (Throwable)e);
        }
    }

    @Override
    public boolean shardExists(UUID uuid) {
        return this.getBackupFile(uuid).isFile();
    }

    @VisibleForTesting
    public File getBackupFile(UUID uuid) {
        return FileStorageService.getFileSystemPath(this.baseDir, uuid);
    }

    private static void createDirectories(File dir) {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed creating directories: " + dir);
        }
    }

    private static void copyFile(File source, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            int n;
            byte[] buffer = new byte[131072];
            while ((n = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            out.flush();
            out.getFD().sync();
        }
    }
}

