/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.backup;

import com.facebook.presto.raptor.backup.BackupStore;
import com.facebook.presto.raptor.backup.ForHttpBackup;
import com.facebook.presto.raptor.backup.HttpBackupConfig;
import com.facebook.presto.raptor.backup.HttpBackupStore;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.node.NodeInfo;
import java.net.URI;
import java.util.function.Supplier;
import javax.inject.Singleton;

public class HttpBackupModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpBackupConfig.class);
        binder.bind(BackupStore.class).to(HttpBackupStore.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("backup", ForHttpBackup.class);
    }

    @Provides
    @Singleton
    @ForHttpBackup
    public String createEnvironment(NodeInfo nodeInfo) {
        return nodeInfo.getEnvironment();
    }

    @Provides
    @Singleton
    @ForHttpBackup
    public Supplier<URI> createBackupUriSupplier(HttpBackupConfig config) {
        URI uri = config.getUri();
        return () -> uri;
    }
}

