/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.H2ShardDao;
import com.facebook.presto.raptor.metadata.MySqlShardDao;
import com.facebook.presto.raptor.metadata.ShardDao;
import com.facebook.presto.raptor.util.ConditionalModule;
import com.facebook.presto.raptor.util.DaoSupplier;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.dbpool.H2EmbeddedDataSourceModule;
import io.airlift.dbpool.MySqlDataSourceModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.tweak.ConnectionFactory;

public class DatabaseMetadataModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindDataSource("metadata", ForMetadata.class);
    }

    @ForMetadata
    @Singleton
    @Provides
    public ConnectionFactory createConnectionFactory(@ForMetadata DataSource dataSource) {
        return dataSource::getConnection;
    }

    private void bindDataSource(String type, Class<? extends Annotation> annotation) {
        String property = type + ".db.type";
        this.install(ConditionalModule.installIfPropertyEquals(property, "mysql", binder -> {
            binder.install((Module)new MySqlDataSourceModule(type, annotation, new Class[0]));
            DatabaseMetadataModule.bindDaoSupplier(binder, ShardDao.class, MySqlShardDao.class);
        }));
        this.install(ConditionalModule.installIfPropertyEquals(property, "h2", binder -> {
            binder.install((Module)new H2EmbeddedDataSourceModule(type, annotation, new Class[0]));
            DatabaseMetadataModule.bindDaoSupplier(binder, ShardDao.class, H2ShardDao.class);
        }));
    }

    public static <B, T extends B> void bindDaoSupplier(Binder binder, Class<B> baseType, Class<T> type) {
        binder.bind(DatabaseMetadataModule.daoSupplierTypeToken(baseType)).toProvider(new DaoSupplierProvider<T>(type)).in(Scopes.SINGLETON);
    }

    private static <T> TypeLiteral<DaoSupplier<? extends T>> daoSupplierTypeToken(Class<T> type) {
        Type javaType = new TypeToken<DaoSupplier<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(type)).getType();
        return TypeLiteral.get((Type)javaType);
    }

    private static class DaoSupplierProvider<T>
    implements Provider<DaoSupplier<T>> {
        private final Class<T> type;
        private Injector injector;

        public DaoSupplierProvider(Class<T> type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public DaoSupplier<T> get() {
            Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"injector was not set");
            IDBI dbi = (IDBI)this.injector.getInstance(Key.get(IDBI.class, ForMetadata.class));
            return new DaoSupplier(dbi, this.type);
        }
    }
}

