/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.metadata.ColumnInfo;
import com.facebook.presto.raptor.metadata.ColumnStats;
import com.facebook.presto.raptor.metadata.DatabaseShardManager;
import com.facebook.presto.raptor.metadata.ShardPredicate;
import com.facebook.presto.raptor.util.ArrayUtil;
import com.facebook.presto.raptor.util.UuidUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.BooleanMapper;

class IndexInserter
implements AutoCloseable {
    private final boolean bucketed;
    private final List<ColumnInfo> columns;
    private final Map<Long, Integer> indexes;
    private final Map<Long, JDBCType> types;
    private final PreparedStatement statement;

    public IndexInserter(Connection connection, long tableId, List<ColumnInfo> columns) throws SQLException {
        this.bucketed = (Boolean)((Query)DBI.open((Connection)connection).createQuery("SELECT distribution_id IS NOT NULL FROM tables WHERE table_id = ?").bind(0, tableId)).map((ResultSetMapper)BooleanMapper.FIRST).first();
        ImmutableList.Builder columnBuilder = ImmutableList.builder();
        ImmutableMap.Builder indexBuilder = ImmutableMap.builder();
        ImmutableMap.Builder typeBuilder = ImmutableMap.builder();
        StringJoiner nameJoiner = new StringJoiner(", ");
        StringJoiner valueJoiner = new StringJoiner(", ");
        int index = 1;
        nameJoiner.add("shard_id").add("shard_uuid");
        valueJoiner.add("?").add("?").add("?");
        index += 3;
        if (this.bucketed) {
            nameJoiner.add("bucket_number");
        } else {
            nameJoiner.add("node_ids");
        }
        for (ColumnInfo column : columns) {
            long columnId;
            JDBCType jdbcType = ShardPredicate.jdbcType(column.getType());
            if (jdbcType == null || RaptorColumnHandle.isHiddenColumn(columnId = column.getColumnId())) continue;
            columnBuilder.add((Object)column);
            nameJoiner.add(DatabaseShardManager.minColumn(columnId));
            nameJoiner.add(DatabaseShardManager.maxColumn(columnId));
            valueJoiner.add("?").add("?");
            indexBuilder.put((Object)columnId, (Object)index);
            index += 2;
            typeBuilder.put((Object)columnId, (Object)jdbcType);
        }
        this.columns = columnBuilder.build();
        this.indexes = indexBuilder.build();
        this.types = typeBuilder.build();
        String sql = "INSERT INTO " + DatabaseShardManager.shardIndexTable(tableId) + "\n(" + nameJoiner + ")\nVALUES (" + valueJoiner + ")";
        this.statement = connection.prepareStatement(sql);
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    public void insert(long shardId, UUID shardUuid, OptionalInt bucketNumber, Set<Integer> nodeIds, List<ColumnStats> stats) throws SQLException {
        int index;
        this.statement.setLong(1, shardId);
        this.statement.setBytes(2, UuidUtil.uuidToBytes(shardUuid));
        if (this.bucketed) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"shard bucket missing for bucketed table");
            this.statement.setInt(3, bucketNumber.getAsInt());
        } else {
            Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0, (Object)"shard bucket present for non-bucketed table");
            this.statement.setBytes(3, ArrayUtil.intArrayToBytes(nodeIds));
        }
        for (ColumnInfo columnInfo : this.columns) {
            index = this.indexes.get(columnInfo.getColumnId());
            int type = this.types.get(columnInfo.getColumnId()).getVendorTypeNumber();
            this.statement.setNull(index, type);
            this.statement.setNull(index + 1, type);
        }
        for (ColumnStats columnStats : stats) {
            index = this.indexes.get(columnStats.getColumnId());
            JDBCType type = this.types.get(columnStats.getColumnId());
            ShardPredicate.bindValue(this.statement, type, IndexInserter.convert(columnStats.getMin()), index);
            ShardPredicate.bindValue(this.statement, type, IndexInserter.convert(columnStats.getMax()), index + 1);
        }
        this.statement.addBatch();
    }

    public void execute() throws SQLException {
        this.statement.executeBatch();
    }

    private static Object convert(Object value) {
        if (value instanceof String) {
            return Slices.utf8Slice((String)((String)value));
        }
        return value;
    }
}

