/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.raptor.util.UuidUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ShardMetadata {
    private final long tableId;
    private final long shardId;
    private final UUID shardUuid;
    private final OptionalInt bucketNumber;
    private final long rowCount;
    private final long compressedSize;
    private final long uncompressedSize;
    private final OptionalLong rangeStart;
    private final OptionalLong rangeEnd;

    public ShardMetadata(long tableId, long shardId, UUID shardUuid, OptionalInt bucketNumber, long rowCount, long compressedSize, long uncompressedSize, OptionalLong rangeStart, OptionalLong rangeEnd) {
        Preconditions.checkArgument((tableId > 0L ? 1 : 0) != 0, (Object)"tableId must be > 0");
        Preconditions.checkArgument((shardId > 0L ? 1 : 0) != 0, (Object)"shardId must be > 0");
        Preconditions.checkArgument((rowCount >= 0L ? 1 : 0) != 0, (Object)"rowCount must be >= 0");
        Preconditions.checkArgument((compressedSize >= 0L ? 1 : 0) != 0, (Object)"compressedSize must be >= 0");
        Preconditions.checkArgument((uncompressedSize >= 0L ? 1 : 0) != 0, (Object)"uncompressedSize must be >= 0");
        this.tableId = tableId;
        this.shardId = shardId;
        this.shardUuid = Objects.requireNonNull(shardUuid, "shardUuid is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.rowCount = rowCount;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.rangeStart = Objects.requireNonNull(rangeStart, "rangeStart is null");
        this.rangeEnd = Objects.requireNonNull(rangeEnd, "rangeEnd is null");
    }

    public long getTableId() {
        return this.tableId;
    }

    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public long getShardId() {
        return this.shardId;
    }

    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public OptionalLong getRangeStart() {
        return this.rangeStart;
    }

    public OptionalLong getRangeEnd() {
        return this.rangeEnd;
    }

    public ShardMetadata withTimeRange(long rangeStart, long rangeEnd) {
        return new ShardMetadata(this.tableId, this.shardId, this.shardUuid, this.bucketNumber, this.rowCount, this.compressedSize, this.uncompressedSize, OptionalLong.of(rangeStart), OptionalLong.of(rangeEnd));
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("shardId", this.shardId).add("shardUuid", (Object)this.shardUuid).add("rowCount", this.rowCount).add("compressedSize", (Object)DataSize.succinctBytes((long)this.compressedSize)).add("uncompressedSize", (Object)DataSize.succinctBytes((long)this.uncompressedSize));
        if (this.bucketNumber.isPresent()) {
            stringHelper.add("bucketNumber", this.bucketNumber.getAsInt());
        }
        if (this.rangeStart.isPresent()) {
            stringHelper.add("rangeStart", this.rangeStart.getAsLong());
        }
        if (this.rangeEnd.isPresent()) {
            stringHelper.add("rangeEnd", this.rangeEnd.getAsLong());
        }
        return stringHelper.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardMetadata that = (ShardMetadata)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.bucketNumber, that.bucketNumber) && Objects.equals(this.rowCount, that.rowCount) && Objects.equals(this.compressedSize, that.compressedSize) && Objects.equals(this.uncompressedSize, that.uncompressedSize) && Objects.equals(this.shardUuid, that.shardUuid) && Objects.equals(this.rangeStart, that.rangeStart) && Objects.equals(this.rangeEnd, that.rangeEnd);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.shardId, this.shardUuid, this.bucketNumber, this.rowCount, this.compressedSize, this.uncompressedSize, this.rangeStart, this.rangeEnd);
    }

    public static class Mapper
    implements ResultSetMapper<ShardMetadata> {
        public ShardMetadata map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new ShardMetadata(r.getLong("table_id"), r.getLong("shard_id"), UuidUtil.uuidFromBytes(r.getBytes("shard_uuid")), DatabaseUtil.getOptionalInt(r, "bucket_number"), r.getLong("row_count"), r.getLong("compressed_size"), r.getLong("uncompressed_size"), OptionalLong.empty(), OptionalLong.empty());
        }
    }
}

