/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.metadata.DatabaseShardManager;
import com.facebook.presto.raptor.storage.ShardStats;
import com.facebook.presto.raptor.util.Types;
import com.facebook.presto.raptor.util.UuidUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.Ranges;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

class ShardPredicate {
    private final String predicate;
    private final List<JDBCType> types;
    private final List<Object> values;

    private ShardPredicate(String predicate, List<JDBCType> types, List<Object> values) {
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
        Preconditions.checkArgument((types.size() == values.size() ? 1 : 0) != 0, (Object)"types and values sizes do not match");
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void bind(PreparedStatement statement) throws SQLException {
        for (int i = 0; i < this.types.size(); ++i) {
            JDBCType type = this.types.get(i);
            Object value = this.values.get(i);
            ShardPredicate.bindValue(statement, type, value, i + 1);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.predicate).toString();
    }

    public static ShardPredicate create(TupleDomain<RaptorColumnHandle> tupleDomain, boolean bucketed) {
        StringJoiner predicate = new StringJoiner(" AND ").setEmptyValue("true");
        ImmutableList.Builder types = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        for (Map.Entry entry : ((Map)tupleDomain.getDomains().get()).entrySet()) {
            String max;
            String min;
            Ranges ranges;
            RaptorColumnHandle handle;
            Type type;
            JDBCType jdbcType;
            Domain domain = (Domain)entry.getValue();
            if (domain.isNullAllowed() || domain.isAll() || (jdbcType = ShardPredicate.jdbcType(type = (handle = (RaptorColumnHandle)entry.getKey()).getColumnType())) == null) continue;
            if (handle.isShardUuid()) {
                predicate.add(ShardPredicate.createShardPredicate((ImmutableList.Builder<JDBCType>)types, (ImmutableList.Builder<Object>)values, domain, jdbcType));
                continue;
            }
            if (!domain.getType().isOrderable() || (ranges = domain.getValues().getRanges()).getRangeCount() != 1) continue;
            Range range = (Range)Iterables.getOnlyElement((Iterable)ranges.getOrderedRanges());
            Object minValue = null;
            Object maxValue = null;
            if (range.isSingleValue()) {
                minValue = range.getSingleValue();
                maxValue = range.getSingleValue();
            } else {
                if (!range.getLow().isLowerUnbounded()) {
                    minValue = range.getLow().getValue();
                }
                if (!range.getHigh().isUpperUnbounded()) {
                    maxValue = range.getHigh().getValue();
                }
            }
            if (handle.isBucketNumber()) {
                if (!bucketed) {
                    predicate.add("false");
                    continue;
                }
                min = "bucket_number";
                max = "bucket_number";
            } else {
                min = DatabaseShardManager.minColumn(handle.getColumnId());
                max = DatabaseShardManager.maxColumn(handle.getColumnId());
            }
            if (minValue != null) {
                predicate.add(String.format("(%s >= ? OR %s IS NULL)", max, max));
                types.add((Object)jdbcType);
                values.add(minValue);
            }
            if (maxValue == null) continue;
            predicate.add(String.format("(%s <= ? OR %s IS NULL)", min, min));
            types.add((Object)jdbcType);
            values.add(maxValue);
        }
        return new ShardPredicate(predicate.toString(), (List<JDBCType>)types.build(), (List<Object>)values.build());
    }

    private static String createShardPredicate(ImmutableList.Builder<JDBCType> types, ImmutableList.Builder<Object> values, Domain domain, JDBCType jdbcType) {
        List ranges = domain.getValues().getRanges().getOrderedRanges();
        if (ranges.isEmpty() || !ranges.stream().allMatch(Range::isSingleValue)) {
            return "true";
        }
        ImmutableList.Builder valuesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        StringJoiner rangePredicate = new StringJoiner(" OR ");
        for (Range range : ranges) {
            Slice uuidText = Types.checkType(range.getSingleValue(), Slice.class, "uuid");
            try {
                Slice uuidBytes = UuidUtil.uuidStringToBytes(uuidText);
                typesBuilder.add((Object)jdbcType);
                valuesBuilder.add((Object)uuidBytes);
            }
            catch (IllegalArgumentException e) {
                return "true";
            }
            rangePredicate.add("shard_uuid = ?");
        }
        types.addAll((Iterable)typesBuilder.build());
        values.addAll((Iterable)valuesBuilder.build());
        return rangePredicate.toString();
    }

    @VisibleForTesting
    protected List<JDBCType> getTypes() {
        return this.types;
    }

    @VisibleForTesting
    protected List<Object> getValues() {
        return this.values;
    }

    public static void bindValue(PreparedStatement statement, JDBCType type, Object value, int index) throws SQLException {
        if (value == null) {
            statement.setNull(index, type.getVendorTypeNumber());
            return;
        }
        switch (type) {
            case BOOLEAN: {
                statement.setBoolean(index, (Boolean)value);
                return;
            }
            case INTEGER: {
                statement.setInt(index, ((Number)value).intValue());
                return;
            }
            case BIGINT: {
                statement.setLong(index, ((Number)value).longValue());
                return;
            }
            case DOUBLE: {
                statement.setDouble(index, ((Number)value).doubleValue());
                return;
            }
            case VARBINARY: {
                statement.setBytes(index, ShardStats.truncateIndexValue((Slice)value).getBytes());
                return;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Unhandled type: " + type);
    }

    public static JDBCType jdbcType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return JDBCType.BOOLEAN;
        }
        if (type.equals(BigintType.BIGINT) || type.equals(TimestampType.TIMESTAMP)) {
            return JDBCType.BIGINT;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return JDBCType.INTEGER;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return JDBCType.DOUBLE;
        }
        if (type.equals(DateType.DATE)) {
            return JDBCType.INTEGER;
        }
        if (type instanceof VarcharType) {
            return JDBCType.VARBINARY;
        }
        return null;
    }
}

