/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.util.DatabaseUtil;
import com.google.common.base.MoreObjects;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public final class Table {
    private final long tableId;
    private final OptionalLong distributionId;
    private final OptionalInt bucketCount;

    public Table(long tableId, OptionalLong distributionId, OptionalInt bucketCount) {
        this.tableId = tableId;
        this.distributionId = Objects.requireNonNull(distributionId, "distributionId is null");
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
    }

    public long getTableId() {
        return this.tableId;
    }

    public OptionalLong getDistributionId() {
        return this.distributionId;
    }

    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.bucketCount);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Table o = (Table)obj;
        return this.tableId == o.tableId && Objects.equals(this.bucketCount, o.bucketCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("distributionId", this.distributionId.isPresent() ? Long.valueOf(this.distributionId.getAsLong()) : null).add("bucketCount", this.bucketCount.isPresent() ? Integer.valueOf(this.bucketCount.getAsInt()) : null).omitNullValues().toString();
    }

    public static class TableMapper
    implements ResultSetMapper<Table> {
        public Table map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new Table(r.getLong("table_id"), DatabaseUtil.getOptionalLong(r, "distribution_id"), DatabaseUtil.getOptionalInt(r, "bucket_count"));
        }
    }
}

