/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.metadata.ColumnInfo;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import javax.inject.Inject;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TableColumn {
    private final SchemaTableName table;
    private final String columnName;
    private final Type dataType;
    private final long columnId;

    public TableColumn(SchemaTableName table, String columnName, Type dataType, long columnId) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.columnId = columnId;
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getDataType() {
        return this.dataType;
    }

    public long getColumnId() {
        return this.columnId;
    }

    public int hashCode() {
        return Objects.hash(this.table, this.columnName, this.dataType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableColumn o = (TableColumn)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.columnName, o.columnName) && Objects.equals(this.dataType, o.dataType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("columnName", (Object)this.columnName).add("dataType", (Object)this.dataType).toString();
    }

    public ColumnMetadata toColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.dataType);
    }

    public ColumnInfo toColumnInfo() {
        return new ColumnInfo(this.columnId, this.dataType);
    }

    public static class Mapper
    implements ResultSetMapper<TableColumn> {
        private final TypeManager typeManager;

        @Inject
        public Mapper(TypeManager typeManager) {
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        public TableColumn map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            SchemaTableName table = new SchemaTableName(r.getString("schema_name"), r.getString("table_name"));
            String typeName = r.getString("data_type");
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object[])new Object[]{typeName});
            return new TableColumn(table, r.getString("column_name"), type, r.getLong("column_id"));
        }
    }
}

