/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.metadata.ShardMetadata;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Set;

public class CompactionSet {
    private final long tableId;
    private final Set<ShardMetadata> shardsToCompact;

    public CompactionSet(long tableId, Set<ShardMetadata> shardsToCompact) {
        this.tableId = tableId;
        this.shardsToCompact = Objects.requireNonNull(shardsToCompact, "shardsToCompact is null");
    }

    public long getTableId() {
        return this.tableId;
    }

    public Set<ShardMetadata> getShardsToCompact() {
        return this.shardsToCompact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionSet that = (CompactionSet)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.shardsToCompact, that.shardsToCompact);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.shardsToCompact);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("shardsToCompact", this.shardsToCompact).toString();
    }
}

