/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.metadata.ShardMetadata;
import com.facebook.presto.raptor.storage.CompactionSet;
import com.facebook.presto.raptor.storage.CompactionSetCreator;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class FileCompactionSetCreator
implements CompactionSetCreator {
    private final DataSize maxShardSize;
    private final long maxShardRows;

    public FileCompactionSetCreator(DataSize maxShardSize, long maxShardRows) {
        this.maxShardSize = Objects.requireNonNull(maxShardSize, "maxShardSize is null");
        Preconditions.checkArgument((maxShardRows > 0L ? 1 : 0) != 0, (Object)"maxShardRows must be > 0");
        this.maxShardRows = maxShardRows;
    }

    @Override
    public Set<CompactionSet> createCompactionSets(long tableId, Set<ShardMetadata> shardMetadata) {
        ImmutableSet.Builder compactionSets = ImmutableSet.builder();
        ImmutableListMultimap map = Multimaps.index(shardMetadata, ShardMetadata::getBucketNumber);
        for (Collection shards : map.asMap().values()) {
            compactionSets.addAll(this.buildCompactionSets(tableId, (Set<ShardMetadata>)ImmutableSet.copyOf((Collection)shards)));
        }
        return compactionSets.build();
    }

    private Set<CompactionSet> buildCompactionSets(long tableId, Set<ShardMetadata> shardMetadata) {
        List shards = shardMetadata.stream().filter(shard -> shard.getUncompressedSize() < this.maxShardSize.toBytes()).filter(shard -> shard.getRowCount() < this.maxShardRows).sorted(Comparator.comparing(ShardMetadata::getUncompressedSize).reversed()).collect(Collectors.toCollection(ArrayList::new));
        ImmutableSet.Builder compactionSets = ImmutableSet.builder();
        while (!shards.isEmpty()) {
            Set<ShardMetadata> compactionSet = this.getCompactionSet(shards);
            Verify.verify((!compactionSet.isEmpty() ? 1 : 0) != 0);
            compactionSets.add((Object)new CompactionSet(tableId, compactionSet));
            shards.removeAll(compactionSet);
        }
        return compactionSets.build();
    }

    private Set<ShardMetadata> getCompactionSet(List<ShardMetadata> shardMetadata) {
        ImmutableSet.Builder shards = ImmutableSet.builder();
        long maxShardSizeBytes = this.maxShardSize.toBytes();
        long consumedBytes = 0L;
        long consumedRows = 0L;
        for (ShardMetadata shard : shardMetadata) {
            if (consumedBytes + shard.getUncompressedSize() > maxShardSizeBytes || consumedRows + shard.getRowCount() > this.maxShardRows) break;
            consumedBytes += shard.getUncompressedSize();
            consumedRows += shard.getRowCount();
            shards.add((Object)shard);
        }
        return shards.build();
    }
}

