/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.storage.OrcFileMetadata;
import com.facebook.presto.raptor.storage.Row;
import com.facebook.presto.raptor.storage.StorageType;
import com.facebook.presto.raptor.util.Types;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class OrcFileWriter
implements Closeable {
    private static final Configuration CONFIGURATION = new Configuration();
    private static final Constructor<? extends FileSinkOperator.RecordWriter> WRITER_CONSTRUCTOR = OrcFileWriter.getOrcWriterConstructor();
    private static final JsonCodec<OrcFileMetadata> METADATA_CODEC = JsonCodec.jsonCodec(OrcFileMetadata.class);
    private final List<Type> columnTypes;
    private final OrcSerde serializer;
    private final FileSinkOperator.RecordWriter recordWriter;
    private final SettableStructObjectInspector tableInspector;
    private final List<StructField> structFields;
    private final Object orcRow;
    private boolean closed;
    private long rowCount;
    private long uncompressedSize;

    public OrcFileWriter(List<Long> columnIds, List<Type> columnTypes, File target) {
        this(columnIds, columnTypes, target, true);
    }

    @VisibleForTesting
    OrcFileWriter(List<Long> columnIds, List<Type> columnTypes, File target, boolean writeMetadata) {
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        Preconditions.checkArgument((columnIds.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"ids and types mismatch");
        Preconditions.checkArgument((boolean)OrcFileWriter.isUnique(columnIds), (Object)"ids must be unique");
        ImmutableList storageTypes = ImmutableList.copyOf(OrcFileWriter.toStorageTypes(columnTypes));
        Iterable hiveTypeNames = storageTypes.stream().map(StorageType::getHiveTypeName).collect(Collectors.toList());
        ImmutableList columnNames = ImmutableList.copyOf((Iterable)Iterables.transform(columnIds, (Function)Functions.toStringFunction()));
        Properties properties = new Properties();
        properties.setProperty("columns", Joiner.on((char)',').join((Iterable)columnNames));
        properties.setProperty("columns.types", Joiner.on((char)':').join(hiveTypeNames));
        this.serializer = OrcFileWriter.createSerializer(CONFIGURATION, properties);
        this.recordWriter = OrcFileWriter.createRecordWriter(new Path(target.toURI()), CONFIGURATION, columnIds, columnTypes, writeMetadata);
        this.tableInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, OrcFileWriter.getJavaObjectInspectors((List<StorageType>)storageTypes));
        this.structFields = ImmutableList.copyOf((Collection)this.tableInspector.getAllStructFieldRefs());
        this.orcRow = this.tableInspector.create();
    }

    public void appendPages(List<Page> pages) {
        for (Page page : pages) {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.appendRow(Row.extractRow(page, position, this.columnTypes));
            }
        }
    }

    public void appendPages(List<Page> inputPages, int[] pageIndexes, int[] positionIndexes) {
        Preconditions.checkArgument((pageIndexes.length == positionIndexes.length ? 1 : 0) != 0, (Object)"pageIndexes and positionIndexes do not match");
        for (int i = 0; i < pageIndexes.length; ++i) {
            Page page = inputPages.get(pageIndexes[i]);
            this.appendRow(Row.extractRow(page, positionIndexes[i], this.columnTypes));
        }
    }

    public void appendRow(Row row) {
        List<Object> columns = row.getColumns();
        Preconditions.checkArgument((columns.size() == this.columnTypes.size() ? 1 : 0) != 0);
        for (int channel = 0; channel < columns.size(); ++channel) {
            this.tableInspector.setStructFieldData(this.orcRow, this.structFields.get(channel), columns.get(channel));
        }
        try {
            this.recordWriter.write(this.serializer.serialize(this.orcRow, (ObjectInspector)this.tableInspector));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to write record", (Throwable)e);
        }
        ++this.rowCount;
        this.uncompressedSize += (long)row.getSizeInBytes();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.recordWriter.close(false);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to close writer", (Throwable)e);
        }
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    private static OrcSerde createSerializer(Configuration conf, Properties properties) {
        OrcSerde serde = new OrcSerde();
        serde.initialize(conf, properties);
        return serde;
    }

    /*
     * Exception decompiling
     */
    private static FileSinkOperator.RecordWriter createRecordWriter(Path target, Configuration conf, List<Long> columnIds, List<Type> columnTypes, boolean writeMetadata) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static OrcFile.WriterCallback createFileMetadataCallback(final List<Long> columnIds, final List<Type> columnTypes) {
        return new OrcFile.WriterCallback(){

            public void preStripeWrite(OrcFile.WriterContext context) throws IOException {
            }

            public void preFooterWrite(OrcFile.WriterContext context) throws IOException {
                ImmutableMap.Builder columnTypesMap = ImmutableMap.builder();
                for (int i = 0; i < columnIds.size(); ++i) {
                    columnTypesMap.put(columnIds.get(i), (Object)((Type)columnTypes.get(i)).getTypeSignature());
                }
                byte[] bytes = METADATA_CODEC.toJsonBytes((Object)new OrcFileMetadata((Map<Long, TypeSignature>)columnTypesMap.build()));
                context.getWriter().addUserMetadata("metadata", ByteBuffer.wrap(bytes));
            }
        };
    }

    private static Constructor<? extends FileSinkOperator.RecordWriter> getOrcWriterConstructor() {
        try {
            String writerClassName = OrcOutputFormat.class.getName() + "$OrcRecordWriter";
            Constructor<FileSinkOperator.RecordWriter> constructor = OrcOutputFormat.class.getClassLoader().loadClass(writerClassName).asSubclass(FileSinkOperator.RecordWriter.class).getDeclaredConstructor(Path.class, OrcFile.WriterOptions.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<ObjectInspector> getJavaObjectInspectors(List<StorageType> types) {
        return types.stream().map(StorageType::getHiveTypeName).map(TypeInfoUtils::getTypeInfoFromTypeString).map(OrcFileWriter::getJavaObjectInspector).collect(Collectors.toList());
    }

    private static ObjectInspector getJavaObjectInspector(TypeInfo typeInfo) {
        ObjectInspector.Category category = typeInfo.getCategory();
        if (category == ObjectInspector.Category.PRIMITIVE) {
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)typeInfo.getTypeName()));
        }
        if (category == ObjectInspector.Category.LIST) {
            ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)OrcFileWriter.getJavaObjectInspector(listTypeInfo.getListElementTypeInfo()));
        }
        if (category == ObjectInspector.Category.MAP) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)OrcFileWriter.getJavaObjectInspector(mapTypeInfo.getMapKeyTypeInfo()), (ObjectInspector)OrcFileWriter.getJavaObjectInspector(mapTypeInfo.getMapValueTypeInfo()));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Unhandled storage type: " + category);
    }

    private static <T> boolean isUnique(Collection<T> items) {
        return new HashSet<T>(items).size() == items.size();
    }

    private static List<StorageType> toStorageTypes(List<Type> columnTypes) {
        return columnTypes.stream().map(OrcFileWriter::toStorageType).collect(Collectors.toList());
    }

    private static StorageType toStorageType(Type type) {
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return StorageType.decimal(decimalType.getPrecision(), decimalType.getScale());
        }
        Class javaType = type.getJavaType();
        if (javaType == Boolean.TYPE) {
            return StorageType.BOOLEAN;
        }
        if (javaType == Long.TYPE) {
            return StorageType.LONG;
        }
        if (javaType == Double.TYPE) {
            return StorageType.DOUBLE;
        }
        if (javaType == Slice.class) {
            if (type instanceof VarcharType) {
                return StorageType.STRING;
            }
            if (type.equals(VarbinaryType.VARBINARY)) {
                return StorageType.BYTES;
            }
        }
        if (Types.isArrayType(type)) {
            return StorageType.arrayOf(OrcFileWriter.toStorageType((Type)type.getTypeParameters().get(0)));
        }
        if (Types.isMapType(type)) {
            return StorageType.mapOf(OrcFileWriter.toStorageType((Type)type.getTypeParameters().get(0)), OrcFileWriter.toStorageType((Type)type.getTypeParameters().get(1)));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "No storage type for type: " + type);
    }
}

