/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.systemtables;

import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.metadata.ColumnMetadataRow;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.TableMetadataRow;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.raptor.util.Types;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.skife.jdbi.v2.IDBI;

public class TableMetadataPageSource
implements ConnectorPageSource {
    public static final String SCHEMA_NAME = "table_schema";
    public static final String TABLE_NAME = "table_name";
    private final List<Type> types;
    private final TupleDomain<Integer> tupleDomain;
    private final ConnectorTableMetadata tableMetadata;
    private final MetadataDao dao;
    private boolean closed;
    private Iterator<Page> pageIterator;

    public TableMetadataPageSource(IDBI dbi, TupleDomain<Integer> tupleDomain, ConnectorTableMetadata tableMetadata) {
        this.dao = DatabaseUtil.onDemandDao(Objects.requireNonNull(dbi, "dbi is null"), MetadataDao.class);
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
        this.types = tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(Collectors.toList());
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public boolean isFinished() {
        this.assureLoaded();
        return !this.pageIterator.hasNext();
    }

    public Page getNextPage() {
        this.assureLoaded();
        return this.pageIterator.next();
    }

    public long getTotalBytes() {
        return 0L;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public void close() {
        this.closed = true;
    }

    private void assureLoaded() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"TableMetadataPageSource is closed");
        if (this.pageIterator != null) {
            return;
        }
        this.pageIterator = this.loadPages(this.tupleDomain);
    }

    private Iterator<Page> loadPages(TupleDomain<Integer> tupleDomain) {
        Map domains = (Map)tupleDomain.getDomains().get();
        Domain schemaNameDomain = (Domain)domains.get(TableMetadataPageSource.getColumnIndex(this.tableMetadata, SCHEMA_NAME));
        Domain tableNameDomain = (Domain)domains.get(TableMetadataPageSource.getColumnIndex(this.tableMetadata, TABLE_NAME));
        String schemaName = schemaNameDomain == null ? null : TableMetadataPageSource.getStringValue(schemaNameDomain.getSingleValue()).toLowerCase(Locale.ENGLISH);
        String tableName = tableNameDomain == null ? null : TableMetadataPageSource.getStringValue(tableNameDomain.getSingleValue()).toLowerCase(Locale.ENGLISH);
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(this.types);
        List<TableMetadataRow> tableRows = this.dao.getTableMetadataRows(schemaName, tableName);
        PeekingIterator columnRowIterator = Iterators.peekingIterator(this.dao.getColumnMetadataRows(schemaName, tableName).iterator());
        for (TableMetadataRow tableRow : tableRows) {
            Object sortOrdinalPosition;
            while (columnRowIterator.hasNext() && ((ColumnMetadataRow)columnRowIterator.peek()).getTableId() < tableRow.getTableId()) {
                columnRowIterator.next();
            }
            String temporalColumnName = null;
            TreeMap<Integer, String> sortColumnNames = new TreeMap<Integer, String>();
            TreeMap<Integer, String> bucketColumnNames = new TreeMap<Integer, String>();
            OptionalLong temporalColumnId = tableRow.getTemporalColumnId();
            while (columnRowIterator.hasNext() && ((ColumnMetadataRow)columnRowIterator.peek()).getTableId() == tableRow.getTableId()) {
                OptionalInt bucketOrdinalPosition;
                ColumnMetadataRow columnRow = (ColumnMetadataRow)columnRowIterator.next();
                if (temporalColumnId.isPresent() && columnRow.getColumnId() == temporalColumnId.getAsLong()) {
                    temporalColumnName = columnRow.getColumnName();
                }
                if (((OptionalInt)(sortOrdinalPosition = columnRow.getSortOrdinalPosition())).isPresent()) {
                    sortColumnNames.put(((OptionalInt)sortOrdinalPosition).getAsInt(), columnRow.getColumnName());
                }
                if (!(bucketOrdinalPosition = columnRow.getBucketOrdinalPosition()).isPresent()) continue;
                bucketColumnNames.put(bucketOrdinalPosition.getAsInt(), columnRow.getColumnName());
            }
            pageBuilder.declarePosition();
            VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(0), Slices.utf8Slice((String)tableRow.getSchemaName()));
            VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(1), Slices.utf8Slice((String)tableRow.getTableName()));
            if (temporalColumnId.isPresent()) {
                if (temporalColumnName == null) {
                    throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_CORRUPT_METADATA, String.format("Table ID %s has corrupt metadata (invalid temporal column ID)", tableRow.getTableId()));
                }
                VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(2), Slices.utf8Slice((String)temporalColumnName));
            } else {
                pageBuilder.getBlockBuilder(2).appendNull();
            }
            if (!sortColumnNames.isEmpty()) {
                BlockBuilder orderingColumnsBlockBuilder = pageBuilder.getBlockBuilder(3).beginBlockEntry();
                sortOrdinalPosition = sortColumnNames.values().iterator();
                while (sortOrdinalPosition.hasNext()) {
                    String sortColumnName = (String)sortOrdinalPosition.next();
                    VarcharType.VARCHAR.writeSlice(orderingColumnsBlockBuilder, Slices.utf8Slice((String)sortColumnName));
                }
                pageBuilder.getBlockBuilder(3).closeEntry();
            } else {
                pageBuilder.getBlockBuilder(3).appendNull();
            }
            Optional<String> distributionName = tableRow.getDistributionName();
            if (distributionName.isPresent()) {
                VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(4), Slices.utf8Slice((String)distributionName.get()));
            } else {
                pageBuilder.getBlockBuilder(4).appendNull();
            }
            OptionalInt bucketCount = tableRow.getBucketCount();
            if (bucketCount.isPresent()) {
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(5), (long)bucketCount.getAsInt());
            } else {
                pageBuilder.getBlockBuilder(5).appendNull();
            }
            if (!bucketColumnNames.isEmpty()) {
                BlockBuilder bucketColumnsBlockBuilder = pageBuilder.getBlockBuilder(6).beginBlockEntry();
                for (String bucketColumnName : bucketColumnNames.values()) {
                    VarcharType.VARCHAR.writeSlice(bucketColumnsBlockBuilder, Slices.utf8Slice((String)bucketColumnName));
                }
                pageBuilder.getBlockBuilder(6).closeEntry();
            } else {
                pageBuilder.getBlockBuilder(6).appendNull();
            }
            if (!pageBuilder.isFull()) continue;
            TableMetadataPageSource.flushPage(pageBuilder, (ImmutableList.Builder<Page>)pages);
        }
        TableMetadataPageSource.flushPage(pageBuilder, (ImmutableList.Builder<Page>)pages);
        return pages.build().iterator();
    }

    private static void flushPage(PageBuilder pageBuilder, ImmutableList.Builder<Page> pages) {
        if (!pageBuilder.isEmpty()) {
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
    }

    private static int getColumnIndex(ConnectorTableMetadata tableMetadata, String columnName) {
        List columns = tableMetadata.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!((ColumnMetadata)columns.get(i)).getName().equals(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column %s not found", columnName));
    }

    private static String getStringValue(Object value) {
        return Types.checkType(value, Slice.class, "value").toStringUtf8();
    }
}

