/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.systemtables;

import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.systemtables.TableMetadataPageSource;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class TableMetadataSystemTable
implements SystemTable {
    private final IDBI dbi;
    private final ConnectorTableMetadata tableMetadata;

    @Inject
    public TableMetadataSystemTable(@ForMetadata IDBI dbi, TypeManager typeManager) {
        this.dbi = Objects.requireNonNull(dbi, "dbi is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        Type arrayOfVarchar = typeManager.getType(TypeSignature.parseTypeSignature((String)"array<varchar>"));
        this.tableMetadata = new ConnectorTableMetadata(new SchemaTableName("system", "tables"), (List)ImmutableList.of((Object)new ColumnMetadata("table_schema", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("table_name", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("temporal_column", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("ordering_columns", arrayOfVarchar), (Object)new ColumnMetadata("distribution_name", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("bucket_count", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("bucketing_columns", arrayOfVarchar)));
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new TableMetadataPageSource(this.dbi, constraint, this.tableMetadata);
    }
}

