/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.node.NodeInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MergingServiceSelector
implements ServiceSelector {
    private final ServiceSelector selector;
    private final Announcer announcer;
    private final NodeInfo nodeInfo;

    public MergingServiceSelector(ServiceSelector selector, Announcer announcer, NodeInfo nodeInfo) {
        this.selector = (ServiceSelector)Preconditions.checkNotNull((Object)selector, (Object)"selector is null");
        this.announcer = (Announcer)Preconditions.checkNotNull((Object)announcer, (Object)"announcer is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
    }

    @Override
    public String getType() {
        return this.selector.getType();
    }

    @Override
    public String getPool() {
        return this.selector.getPool();
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        return this.merge(this.announcer.getServiceAnnouncements(), this.selector.selectAllServices());
    }

    @Override
    public ListenableFuture<List<ServiceDescriptor>> refresh() {
        return Futures.transform(this.selector.refresh(), descriptors -> this.merge(this.announcer.getServiceAnnouncements(), (List<ServiceDescriptor>)descriptors));
    }

    private List<ServiceDescriptor> merge(Set<ServiceAnnouncement> serviceAnnouncements, List<ServiceDescriptor> serviceDescriptors) {
        HashSet<ServiceDescriptor> set = new HashSet<ServiceDescriptor>();
        for (ServiceAnnouncement announcement : serviceAnnouncements) {
            ServiceDescriptor descriptor = announcement.toServiceDescriptor(this.nodeInfo);
            if (!descriptor.getType().equals(this.getType()) || !descriptor.getPool().equals(this.getPool())) continue;
            set.add(descriptor);
        }
        set.addAll(serviceDescriptors);
        return ImmutableList.copyOf(set);
    }
}

