/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import io.airlift.slice.ChunkedSliceInput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.RuntimeIOException;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractOrcDataSource
implements OrcDataSource {
    private final String name;
    private final long size;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final DataSize streamBufferSize;
    private long readTimeNanos;
    private long readBytes;

    public AbstractOrcDataSource(String name, long size, DataSize maxMergeDistance, DataSize maxBufferSize, DataSize streamBufferSize) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.size = size;
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size is negative");
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.streamBufferSize = Objects.requireNonNull(streamBufferSize, "streamBufferSize is null");
    }

    protected abstract void readInternal(long var1, byte[] var3, int var4, int var5) throws IOException;

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public final void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)bufferLength;
    }

    @Override
    public final <K> Map<K, FixedLengthSliceInput> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        Objects.requireNonNull(diskRanges, "diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        long maxReadSizeBytes = this.maxBufferSize.toBytes();
        ImmutableMap.Builder smallRangesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder largeRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            if ((long)entry.getValue().getLength() <= maxReadSizeBytes) {
                smallRangesBuilder.put(entry);
                continue;
            }
            largeRangesBuilder.put(entry);
        }
        ImmutableMap smallRanges = smallRangesBuilder.build();
        ImmutableMap largeRanges = largeRangesBuilder.build();
        ImmutableMap.Builder slices = ImmutableMap.builder();
        slices.putAll(this.readSmallDiskRanges((Map<K, DiskRange>)smallRanges));
        slices.putAll(this.readLargeDiskRanges((Map<K, DiskRange>)largeRanges));
        return slices.build();
    }

    private <K> Map<K, FixedLengthSliceInput> readSmallDiskRanges(Map<K, DiskRange> diskRanges) throws IOException {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        List<DiskRange> mergedRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(diskRanges.values(), this.maxMergeDistance, this.maxBufferSize);
        LinkedHashMap<DiskRange, byte[]> buffers = new LinkedHashMap<DiskRange, byte[]>();
        for (DiskRange mergedRange : mergedRanges) {
            byte[] buffer = new byte[mergedRange.getLength()];
            this.readFully(mergedRange.getOffset(), buffer);
            buffers.put(mergedRange, buffer);
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            slices.put(entry.getKey(), (Object)OrcDataSourceUtils.getDiskRangeSlice(entry.getValue(), buffers).getInput());
        }
        return slices.build();
    }

    private <K> Map<K, FixedLengthSliceInput> readLargeDiskRanges(Map<K, DiskRange> diskRanges) throws IOException {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            ChunkedSliceInput sliceInput = new ChunkedSliceInput((ChunkedSliceInput.SliceLoader)new HdfsSliceLoader(entry.getValue()), Ints.checkedCast((long)this.streamBufferSize.toBytes()));
            slices.put(entry.getKey(), (Object)sliceInput);
        }
        return slices.build();
    }

    public final String toString() {
        return this.name;
    }

    private static class SliceBufferReference
    implements ChunkedSliceInput.BufferReference {
        private final byte[] buffer;
        private final Slice slice;

        public SliceBufferReference(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.slice = Slices.wrappedBuffer((byte[])this.buffer);
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public Slice getSlice() {
            return this.slice;
        }
    }

    private class HdfsSliceLoader
    implements ChunkedSliceInput.SliceLoader<SliceBufferReference> {
        private final DiskRange diskRange;

        public HdfsSliceLoader(DiskRange diskRange) {
            this.diskRange = diskRange;
        }

        public SliceBufferReference createBuffer(int bufferSize) {
            return new SliceBufferReference(bufferSize);
        }

        public long getSize() {
            return this.diskRange.getLength();
        }

        public void load(long position, SliceBufferReference bufferReference, int length) {
            try {
                AbstractOrcDataSource.this.readFully(this.diskRange.getOffset() + position, bufferReference.getBuffer(), 0, length);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void close() {
        }
    }
}

