/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.CachingOrcDataSource;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.memory.AbstractAggregatedMemoryContext;
import com.facebook.presto.orc.memory.AggregatedMemoryContext;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class OrcReader {
    public static final int MAX_BATCH_SIZE = 1024;
    private static final Logger log = Logger.get(OrcReader.class);
    private static final Slice MAGIC = Slices.utf8Slice((String)"ORC");
    private static final int CURRENT_MAJOR_VERSION = 0;
    private static final int CURRENT_MINOR_VERSION = 12;
    private static final int EXPECTED_FOOTER_SIZE = 16384;
    private final OrcDataSource orcDataSource;
    private final MetadataReader metadataReader;
    private final DataSize maxMergeDistance;
    private final DataSize maxReadSize;
    private final CompressionKind compressionKind;
    private final int bufferSize;
    private final Footer footer;
    private final Metadata metadata;

    public OrcReader(OrcDataSource orcDataSource, MetadataReader metadataReader, DataSize maxMergeDistance, DataSize maxReadSize) throws IOException {
        Slice completeFooterSlice;
        this.orcDataSource = orcDataSource = OrcReader.wrapWithCacheIfTiny(Objects.requireNonNull(orcDataSource, "orcDataSource is null"), maxMergeDistance);
        this.metadataReader = Objects.requireNonNull(metadataReader, "metadataReader is null");
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxReadSize = Objects.requireNonNull(maxReadSize, "maxReadSize is null");
        long size = orcDataSource.getSize();
        if (size <= 0L) {
            throw new OrcCorruptionException("Malformed ORC file %s. Invalid file size %s", orcDataSource, size);
        }
        byte[] buffer = new byte[Ints.checkedCast((long)Math.min(size, 16384L))];
        orcDataSource.readFully(size - (long)buffer.length, buffer);
        int postScriptSize = buffer[buffer.length - 1] & 0xFF;
        OrcReader.verifyOrcFooter(orcDataSource, postScriptSize, buffer);
        int postScriptOffset = buffer.length - 1 - postScriptSize;
        PostScript postScript = metadataReader.readPostScript(buffer, postScriptOffset, postScriptSize);
        OrcReader.checkOrcVersion(orcDataSource, postScript.getVersion());
        this.compressionKind = postScript.getCompression();
        this.bufferSize = Ints.checkedCast((long)postScript.getCompressionBlockSize());
        int footerSize = Ints.checkedCast((long)postScript.getFooterLength());
        int metadataSize = Ints.checkedCast((long)postScript.getMetadataLength());
        int completeFooterSize = footerSize + metadataSize + postScriptSize + 1;
        if (completeFooterSize > buffer.length) {
            byte[] newBuffer = new byte[completeFooterSize];
            completeFooterSlice = Slices.wrappedBuffer((byte[])newBuffer);
            orcDataSource.readFully(size - (long)completeFooterSize, newBuffer, 0, completeFooterSize - buffer.length);
            completeFooterSlice.setBytes(completeFooterSize - buffer.length, buffer);
        } else {
            completeFooterSlice = Slices.wrappedBuffer((byte[])buffer, (int)(buffer.length - completeFooterSize), (int)completeFooterSize);
        }
        Slice metadataSlice = completeFooterSlice.slice(0, metadataSize);
        try (OrcInputStream metadataInputStream = new OrcInputStream(orcDataSource.toString(), (FixedLengthSliceInput)metadataSlice.getInput(), this.compressionKind, this.bufferSize, new AggregatedMemoryContext());){
            this.metadata = metadataReader.readMetadata(metadataInputStream);
        }
        Slice footerSlice = completeFooterSlice.slice(metadataSize, footerSize);
        try (OrcInputStream footerInputStream = new OrcInputStream(orcDataSource.toString(), (FixedLengthSliceInput)footerSlice.getInput(), this.compressionKind, this.bufferSize, new AggregatedMemoryContext());){
            this.footer = metadataReader.readFooter(footerInputStream);
        }
    }

    public List<String> getColumnNames() {
        return this.footer.getTypes().get(0).getFieldNames();
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public OrcRecordReader createRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, DateTimeZone hiveStorageTimeZone, AbstractAggregatedMemoryContext systemMemoryUsage) throws IOException {
        return this.createRecordReader(includedColumns, predicate, 0L, this.orcDataSource.getSize(), hiveStorageTimeZone, systemMemoryUsage);
    }

    public OrcRecordReader createRecordReader(Map<Integer, Type> includedColumns, OrcPredicate predicate, long offset, long length, DateTimeZone hiveStorageTimeZone, AbstractAggregatedMemoryContext systemMemoryUsage) throws IOException {
        return new OrcRecordReader(Objects.requireNonNull(includedColumns, "includedColumns is null"), Objects.requireNonNull(predicate, "predicate is null"), this.footer.getNumberOfRows(), this.footer.getStripes(), this.footer.getFileStats(), this.metadata.getStripeStatsList(), this.orcDataSource, offset, length, this.footer.getTypes(), this.compressionKind, this.bufferSize, this.footer.getRowsInRowGroup(), Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null"), this.metadataReader, this.maxMergeDistance, this.maxReadSize, this.footer.getUserMetadata(), systemMemoryUsage);
    }

    private static OrcDataSource wrapWithCacheIfTiny(OrcDataSource dataSource, DataSize maxCacheSize) {
        if (dataSource instanceof CachingOrcDataSource) {
            return dataSource;
        }
        if (dataSource.getSize() > maxCacheSize.toBytes()) {
            return dataSource;
        }
        DiskRange diskRange = new DiskRange(0L, Ints.checkedCast((long)dataSource.getSize()));
        return new CachingOrcDataSource(dataSource, desiredOffset -> diskRange);
    }

    private static void verifyOrcFooter(OrcDataSource source, int postScriptSize, byte[] buffer) throws IOException {
        int magicLength = MAGIC.length();
        if (postScriptSize < magicLength + 1) {
            throw new OrcCorruptionException("Malformed ORC file %s. Invalid postscript length %s", source, postScriptSize);
        }
        if (!MAGIC.equals((Object)Slices.wrappedBuffer((byte[])buffer, (int)(buffer.length - 1 - magicLength), (int)magicLength))) {
            byte[] headerMagic = new byte[magicLength];
            source.readFully(0L, headerMagic);
            if (!MAGIC.equals((Object)Slices.wrappedBuffer((byte[])headerMagic))) {
                throw new OrcCorruptionException("Malformed ORC file %s. Invalid postscript.", source);
            }
        }
    }

    private static void checkOrcVersion(OrcDataSource orcDataSource, List<Integer> version) {
        if (version.size() >= 1) {
            int major = version.get(0);
            int minor = 0;
            if (version.size() > 1) {
                minor = version.get(1);
            }
            if (major > 0 || major == 0 && minor > 12) {
                log.warn("ORC file %s was written by a newer Hive version %s. This file may not be readable by this version of Hive (%s.%s).", new Object[]{orcDataSource, Joiner.on((char)'.').join(version), 0, 12});
            }
        }
    }
}

