/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.hive.protobuf.CodedInputStream;
import com.facebook.presto.orc.metadata.BooleanStatistics;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DateStatistics;
import com.facebook.presto.orc.metadata.DecimalStatistics;
import com.facebook.presto.orc.metadata.DoubleStatistics;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.IntegerStatistics;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StringStatistics;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.StripeStatistics;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;

public class OrcMetadataReader
implements MetadataReader {
    private static final Slice MAX_BYTE = Slices.wrappedBuffer((byte[])new byte[]{-1});

    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((byte[])data, (int)offset, (int)length);
        OrcProto.PostScript postScript = OrcProto.PostScript.parseFrom((CodedInputStream)input);
        return new PostScript(postScript.getVersionList(), postScript.getFooterLength(), postScript.getMetadataLength(), OrcMetadataReader.toCompression(postScript.getCompression()), postScript.getCompressionBlockSize());
    }

    @Override
    public Metadata readMetadata(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.Metadata metadata = OrcProto.Metadata.parseFrom((CodedInputStream)input);
        return new Metadata(OrcMetadataReader.toStripeStatistics(metadata.getStripeStatsList()));
    }

    private static List<StripeStatistics> toStripeStatistics(List<OrcProto.StripeStatistics> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, OrcMetadataReader::toStripeStatistics));
    }

    private static StripeStatistics toStripeStatistics(OrcProto.StripeStatistics stripeStatistics) {
        return new StripeStatistics(OrcMetadataReader.toColumnStatistics(stripeStatistics.getColStatsList(), false));
    }

    @Override
    public Footer readFooter(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.Footer footer = OrcProto.Footer.parseFrom((CodedInputStream)input);
        return new Footer(footer.getNumberOfRows(), footer.getRowIndexStride(), OrcMetadataReader.toStripeInformation(footer.getStripesList()), OrcMetadataReader.toType(footer.getTypesList()), OrcMetadataReader.toColumnStatistics(footer.getStatisticsList(), false), this.toUserMetadata(footer.getMetadataList()));
    }

    private static List<StripeInformation> toStripeInformation(List<OrcProto.StripeInformation> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, OrcMetadataReader::toStripeInformation));
    }

    private static StripeInformation toStripeInformation(OrcProto.StripeInformation stripeInformation) {
        return new StripeInformation(Ints.checkedCast((long)stripeInformation.getNumberOfRows()), stripeInformation.getOffset(), stripeInformation.getIndexLength(), stripeInformation.getDataLength(), stripeInformation.getFooterLength());
    }

    @Override
    public StripeFooter readStripeFooter(List<OrcType> types, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.StripeFooter stripeFooter = OrcProto.StripeFooter.parseFrom((CodedInputStream)input);
        return new StripeFooter(OrcMetadataReader.toStream(stripeFooter.getStreamsList()), OrcMetadataReader.toColumnEncoding(stripeFooter.getColumnsList()));
    }

    private static Stream toStream(OrcProto.Stream stream) {
        return new Stream(stream.getColumn(), OrcMetadataReader.toStreamKind(stream.getKind()), Ints.checkedCast((long)stream.getLength()), true);
    }

    private static List<Stream> toStream(List<OrcProto.Stream> streams) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(streams, OrcMetadataReader::toStream));
    }

    private static ColumnEncoding toColumnEncoding(OrcProto.ColumnEncoding columnEncoding) {
        return new ColumnEncoding(OrcMetadataReader.toColumnEncodingKind(columnEncoding.getKind()), columnEncoding.getDictionarySize());
    }

    private static List<ColumnEncoding> toColumnEncoding(List<OrcProto.ColumnEncoding> columnEncodings) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(columnEncodings, OrcMetadataReader::toColumnEncoding));
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.RowIndex rowIndex = OrcProto.RowIndex.parseFrom((CodedInputStream)input);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)rowIndex.getEntryList(), OrcMetadataReader::toRowGroupIndex));
    }

    private static RowGroupIndex toRowGroupIndex(OrcProto.RowIndexEntry rowIndexEntry) {
        List positionsList = rowIndexEntry.getPositionsList();
        ImmutableList.Builder positions = ImmutableList.builder();
        for (int index = 0; index < positionsList.size(); ++index) {
            long longPosition = (Long)positionsList.get(index);
            int intPosition = (int)longPosition;
            Preconditions.checkState(((long)intPosition == longPosition ? 1 : 0) != 0, (String)"Expected checkpoint position %s, to be an integer", (Object[])new Object[]{index});
            positions.add((Object)intPosition);
        }
        return new RowGroupIndex((List<Integer>)positions.build(), OrcMetadataReader.toColumnStatistics(rowIndexEntry.getStatistics(), true));
    }

    private static ColumnStatistics toColumnStatistics(OrcProto.ColumnStatistics statistics, boolean isRowGroup) {
        return new ColumnStatistics(statistics.getNumberOfValues(), OrcMetadataReader.toBooleanStatistics(statistics.getBucketStatistics()), OrcMetadataReader.toIntegerStatistics(statistics.getIntStatistics()), OrcMetadataReader.toDoubleStatistics(statistics.getDoubleStatistics()), OrcMetadataReader.toStringStatistics(statistics.getStringStatistics(), isRowGroup), OrcMetadataReader.toDateStatistics(statistics.getDateStatistics(), isRowGroup), OrcMetadataReader.toDecimalStatistics(statistics.getDecimalStatistics()));
    }

    private static List<ColumnStatistics> toColumnStatistics(List<OrcProto.ColumnStatistics> columnStatistics, boolean isRowGroup) {
        if (columnStatistics == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(columnStatistics, statistics -> OrcMetadataReader.toColumnStatistics(statistics, isRowGroup)));
    }

    private Map<String, Slice> toUserMetadata(List<OrcProto.UserMetadataItem> metadataList) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (OrcProto.UserMetadataItem item : metadataList) {
            mapBuilder.put((Object)item.getName(), (Object)Slices.wrappedBuffer((byte[])item.getValue().toByteArray()));
        }
        return mapBuilder.build();
    }

    private static BooleanStatistics toBooleanStatistics(OrcProto.BucketStatistics bucketStatistics) {
        if (bucketStatistics.getCountCount() == 0) {
            return null;
        }
        return new BooleanStatistics(bucketStatistics.getCount(0));
    }

    private static IntegerStatistics toIntegerStatistics(OrcProto.IntegerStatistics integerStatistics) {
        if (!integerStatistics.hasMinimum() && !integerStatistics.hasMaximum()) {
            return null;
        }
        return new IntegerStatistics(integerStatistics.hasMinimum() ? Long.valueOf(integerStatistics.getMinimum()) : null, integerStatistics.hasMaximum() ? Long.valueOf(integerStatistics.getMaximum()) : null);
    }

    private static DoubleStatistics toDoubleStatistics(OrcProto.DoubleStatistics doubleStatistics) {
        if (!doubleStatistics.hasMinimum() && !doubleStatistics.hasMaximum()) {
            return null;
        }
        if (doubleStatistics.hasMinimum() && Double.isNaN(doubleStatistics.getMinimum()) || doubleStatistics.hasMaximum() && Double.isNaN(doubleStatistics.getMaximum()) || doubleStatistics.hasSum() && Double.isNaN(doubleStatistics.getSum())) {
            return null;
        }
        return new DoubleStatistics(doubleStatistics.hasMinimum() ? Double.valueOf(doubleStatistics.getMinimum()) : null, doubleStatistics.hasMaximum() ? Double.valueOf(doubleStatistics.getMaximum()) : null);
    }

    private static StringStatistics toStringStatistics(OrcProto.StringStatistics stringStatistics, boolean isRowGroup) {
        if (!isRowGroup) {
            return null;
        }
        if (!stringStatistics.hasMinimum() && !stringStatistics.hasMaximum()) {
            return null;
        }
        Slice minimum = stringStatistics.hasMinimum() ? OrcMetadataReader.getMinSlice(stringStatistics.getMinimum()) : null;
        Slice maximum = stringStatistics.hasMaximum() ? OrcMetadataReader.getMaxSlice(stringStatistics.getMaximum()) : null;
        return new StringStatistics(minimum, maximum);
    }

    private static DecimalStatistics toDecimalStatistics(OrcProto.DecimalStatistics decimalStatistics) {
        if (!decimalStatistics.hasMinimum() && !decimalStatistics.hasMaximum()) {
            return null;
        }
        BigDecimal minimum = decimalStatistics.hasMinimum() ? new BigDecimal(decimalStatistics.getMinimum()) : null;
        BigDecimal maximum = decimalStatistics.hasMaximum() ? new BigDecimal(decimalStatistics.getMaximum()) : null;
        return new DecimalStatistics(minimum, maximum);
    }

    @VisibleForTesting
    public static Slice getMaxSlice(String maximum) {
        if (maximum == null) {
            return null;
        }
        int index = OrcMetadataReader.firstSurrogateCharacter(maximum);
        if (index == -1) {
            return Slices.utf8Slice((String)maximum);
        }
        return OrcMetadataReader.concatSlices(Slices.utf8Slice((String)maximum.substring(0, index)), MAX_BYTE);
    }

    @VisibleForTesting
    public static Slice getMinSlice(String minimum) {
        if (minimum == null) {
            return null;
        }
        int index = OrcMetadataReader.firstSurrogateCharacter(minimum);
        if (index == -1) {
            return Slices.utf8Slice((String)minimum);
        }
        return Slices.utf8Slice((String)minimum.substring(0, index));
    }

    @VisibleForTesting
    static int firstSurrogateCharacter(String value) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < '\ud800') continue;
            return i;
        }
        return -1;
    }

    @VisibleForTesting
    static Slice concatSlices(Slice slice1, Slice slice2) {
        Slice slice = Slices.allocate((int)(slice1.length() + slice2.length()));
        slice.setBytes(0, slice1.getBytes());
        slice.setBytes(slice1.length(), slice2.getBytes());
        return slice;
    }

    private static DateStatistics toDateStatistics(OrcProto.DateStatistics dateStatistics, boolean isRowGroup) {
        if (!isRowGroup) {
            return null;
        }
        if (!dateStatistics.hasMinimum() && !dateStatistics.hasMaximum()) {
            return null;
        }
        return new DateStatistics(dateStatistics.hasMinimum() ? Integer.valueOf(dateStatistics.getMinimum()) : null, dateStatistics.hasMaximum() ? Integer.valueOf(dateStatistics.getMaximum()) : null);
    }

    private static OrcType toType(OrcProto.Type type) {
        Optional<Integer> precision = Optional.empty();
        Optional<Integer> scale = Optional.empty();
        if (type.getKind() == OrcProto.Type.Kind.DECIMAL) {
            precision = Optional.of(type.getPrecision());
            scale = Optional.of(type.getScale());
        }
        return new OrcType(OrcMetadataReader.toTypeKind(type.getKind()), type.getSubtypesList(), type.getFieldNamesList(), precision, scale);
    }

    private static List<OrcType> toType(List<OrcProto.Type> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, OrcMetadataReader::toType));
    }

    private static OrcType.OrcTypeKind toTypeKind(OrcProto.Type.Kind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return OrcType.OrcTypeKind.BOOLEAN;
            }
            case BYTE: {
                return OrcType.OrcTypeKind.BYTE;
            }
            case SHORT: {
                return OrcType.OrcTypeKind.SHORT;
            }
            case INT: {
                return OrcType.OrcTypeKind.INT;
            }
            case LONG: {
                return OrcType.OrcTypeKind.LONG;
            }
            case FLOAT: {
                return OrcType.OrcTypeKind.FLOAT;
            }
            case DOUBLE: {
                return OrcType.OrcTypeKind.DOUBLE;
            }
            case STRING: {
                return OrcType.OrcTypeKind.STRING;
            }
            case BINARY: {
                return OrcType.OrcTypeKind.BINARY;
            }
            case TIMESTAMP: {
                return OrcType.OrcTypeKind.TIMESTAMP;
            }
            case LIST: {
                return OrcType.OrcTypeKind.LIST;
            }
            case MAP: {
                return OrcType.OrcTypeKind.MAP;
            }
            case STRUCT: {
                return OrcType.OrcTypeKind.STRUCT;
            }
            case UNION: {
                return OrcType.OrcTypeKind.UNION;
            }
            case DECIMAL: {
                return OrcType.OrcTypeKind.DECIMAL;
            }
            case DATE: {
                return OrcType.OrcTypeKind.DATE;
            }
            case VARCHAR: {
                return OrcType.OrcTypeKind.VARCHAR;
            }
            case CHAR: {
                return OrcType.OrcTypeKind.CHAR;
            }
        }
        throw new IllegalStateException(typeKind + " stream type not implemented yet");
    }

    private static Stream.StreamKind toStreamKind(OrcProto.Stream.Kind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return Stream.StreamKind.PRESENT;
            }
            case DATA: {
                return Stream.StreamKind.DATA;
            }
            case LENGTH: {
                return Stream.StreamKind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return Stream.StreamKind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return Stream.StreamKind.DICTIONARY_COUNT;
            }
            case SECONDARY: {
                return Stream.StreamKind.SECONDARY;
            }
            case ROW_INDEX: {
                return Stream.StreamKind.ROW_INDEX;
            }
        }
        throw new IllegalStateException(streamKind + " stream type not implemented yet");
    }

    private static ColumnEncoding.ColumnEncodingKind toColumnEncodingKind(OrcProto.ColumnEncoding.Kind columnEncodingKind) {
        switch (columnEncodingKind) {
            case DIRECT: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT;
            }
            case DIRECT_V2: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT_V2;
            }
            case DICTIONARY: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY;
            }
            case DICTIONARY_V2: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2;
            }
        }
        throw new IllegalStateException(columnEncodingKind + " stream encoding not implemented yet");
    }

    private static CompressionKind toCompression(OrcProto.CompressionKind compression) {
        switch (compression) {
            case NONE: {
                return CompressionKind.UNCOMPRESSED;
            }
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
        }
        throw new IllegalStateException(compression + " compression not implemented yet");
    }
}

