/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.DecimalStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DecimalStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private boolean[] nullVector = new boolean[0];
    private long[] shortDecimalVector = new long[0];
    private BigInteger[] longDecimalVector = new BigInteger[0];
    private long[] scaleVector = new long[0];
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    @Nonnull
    private StreamSource<DecimalStream> decimalStreamSource = MissingStreamSource.missingStreamSource(DecimalStream.class);
    @Nullable
    private DecimalStream decimalStream;
    @Nonnull
    private StreamSource<LongStream> scaleStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream scaleStream;
    private boolean rowGroupOpen;

    public DecimalStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        DecimalType decimalType = (DecimalType)type;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.seekToOffset();
        this.allocateVectors();
        this.readStreamsData(decimalType);
        Block block = this.buildDecimalsBlock(decimalType);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.decimalStream = this.decimalStreamSource.openStream();
        this.scaleStream = this.scaleStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private void seekToOffset() throws IOException {
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.decimalStream == null) {
                    throw new OrcCorruptionException("Value is not null but decimal stream is not present");
                }
                if (this.scaleStream == null) {
                    throw new OrcCorruptionException("Value is not null but scale stream is not present");
                }
                this.decimalStream.skip(this.readOffset);
                this.scaleStream.skip(this.readOffset);
            }
        }
    }

    private void allocateVectors() {
        if (this.nullVector.length < this.nextBatchSize) {
            this.nullVector = new boolean[this.nextBatchSize];
            this.shortDecimalVector = new long[this.nextBatchSize];
            this.longDecimalVector = new BigInteger[this.nextBatchSize];
            this.scaleVector = new long[this.nextBatchSize];
        }
    }

    private void readStreamsData(DecimalType decimalType) throws IOException {
        if (this.presentStream == null) {
            if (this.decimalStream == null) {
                throw new OrcCorruptionException("Value is not null but decimal stream is not present");
            }
            if (this.scaleStream == null) {
                throw new OrcCorruptionException("Value is not null but scale stream is not present");
            }
            Arrays.fill(this.nullVector, false);
            if (decimalType.isShort()) {
                this.decimalStream.nextLongVector(this.nextBatchSize, this.shortDecimalVector);
            } else {
                this.decimalStream.nextBigIntegerVector(this.nextBatchSize, this.longDecimalVector);
            }
            this.scaleStream.nextLongVector(this.nextBatchSize, this.scaleVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.decimalStream == null) {
                    throw new OrcCorruptionException("Value is not null but decimal stream is not present");
                }
                if (this.scaleStream == null) {
                    throw new OrcCorruptionException("Value is not null but scale stream is not present");
                }
                if (decimalType.isShort()) {
                    this.decimalStream.nextLongVector(this.nextBatchSize, this.shortDecimalVector, this.nullVector);
                } else {
                    this.decimalStream.nextBigIntegerVector(this.nextBatchSize, this.longDecimalVector, this.nullVector);
                }
                this.scaleStream.nextLongVector(this.nextBatchSize, this.scaleVector, this.nullVector);
            }
        }
    }

    private Block buildDecimalsBlock(DecimalType decimalType) throws OrcCorruptionException {
        BlockBuilder builder = decimalType.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
        if (decimalType.isShort()) {
            for (int i = 0; i < this.nextBatchSize; ++i) {
                if (!this.nullVector[i]) {
                    long rescaledDecimal = Decimals.rescale((long)this.shortDecimalVector[i], (int)((int)this.scaleVector[i]), (int)decimalType.getScale());
                    decimalType.writeLong(builder, rescaledDecimal);
                    continue;
                }
                builder.appendNull();
            }
        } else {
            for (int i = 0; i < this.nextBatchSize; ++i) {
                if (!this.nullVector[i]) {
                    BigInteger rescaledDecimal = Decimals.rescale((BigInteger)this.longDecimalVector[i], (int)((int)this.scaleVector[i]), (int)decimalType.getScale());
                    Slice slice = Decimals.encodeUnscaledValue((BigInteger)rescaledDecimal);
                    decimalType.writeSlice(builder, slice);
                    continue;
                }
                builder.appendNull();
            }
        }
        return builder.build();
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.decimalStreamSource = MissingStreamSource.missingStreamSource(DecimalStream.class);
        this.scaleStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.decimalStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, DecimalStream.class);
        this.scaleStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

