/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.checkpoint.InputStreamCheckpoint;
import com.facebook.presto.orc.memory.AbstractAggregatedMemoryContext;
import com.facebook.presto.orc.memory.LocalMemoryContext;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.iq80.snappy.Snappy;
import sun.misc.Unsafe;

public final class OrcInputStream
extends InputStream {
    public static final int EXPECTED_COMPRESSION_RATIO = 5;
    private final String source;
    private final FixedLengthSliceInput compressedSliceInput;
    private final CompressionKind compressionKind;
    private final int maxBufferSize;
    private int currentCompressedBlockOffset;
    private FixedLengthSliceInput current;
    private byte[] buffer;
    private final LocalMemoryContext bufferMemoryUsage;
    private final LocalMemoryContext fixedMemoryUsage;

    public OrcInputStream(String source, FixedLengthSliceInput sliceInput, CompressionKind compressionKind, int bufferSize, AbstractAggregatedMemoryContext systemMemoryContext) {
        this.source = Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(sliceInput, "sliceInput is null");
        this.compressionKind = Objects.requireNonNull(compressionKind, "compressionKind is null");
        this.maxBufferSize = bufferSize;
        Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.bufferMemoryUsage = systemMemoryContext.newLocalMemoryContext();
        this.fixedMemoryUsage = systemMemoryContext.newLocalMemoryContext();
        this.fixedMemoryUsage.setBytes(sliceInput.length());
        if (compressionKind == CompressionKind.UNCOMPRESSED) {
            this.current = sliceInput;
            this.compressedSliceInput = Slices.EMPTY_SLICE.getInput();
        } else {
            Preconditions.checkArgument((compressionKind == CompressionKind.SNAPPY || compressionKind == CompressionKind.ZLIB ? 1 : 0) != 0, (String)"%s compression not supported", (Object[])new Object[]{compressionKind});
            this.compressedSliceInput = sliceInput;
            this.current = Slices.EMPTY_SLICE.getInput();
        }
    }

    @Override
    public void close() throws IOException {
        this.current = null;
        this.fixedMemoryUsage.setBytes(this.compressedSliceInput.length());
        this.buffer = null;
        this.bufferMemoryUsage.setBytes(0L);
    }

    @Override
    public int available() throws IOException {
        if (this.current == null) {
            return 0;
        }
        return this.current.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        int result = this.current.read();
        if (result != -1) {
            return result;
        }
        this.advance();
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.current.remaining() == 0L) {
            this.advance();
            if (this.current == null) {
                return -1;
            }
        }
        return this.current.read(b, off, length);
    }

    public long getCheckpoint() {
        if (this.current == null || this.current.position() == 0L && this.current.remaining() == 0L) {
            return InputStreamCheckpoint.createInputStreamCheckpoint(Ints.checkedCast((long)this.compressedSliceInput.position()), 0);
        }
        return InputStreamCheckpoint.createInputStreamCheckpoint(this.currentCompressedBlockOffset, Ints.checkedCast((long)this.current.position()));
    }

    public boolean seekToCheckpoint(long checkpoint) throws IOException {
        boolean discardedBuffer;
        int compressedBlockOffset = InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint);
        int decompressedOffset = InputStreamCheckpoint.decodeDecompressedOffset(checkpoint);
        if (compressedBlockOffset != this.currentCompressedBlockOffset) {
            if (this.compressionKind == CompressionKind.UNCOMPRESSED) {
                throw new OrcCorruptionException("Reset stream has a compressed block offset but stream is not compressed");
            }
            this.compressedSliceInput.setPosition((long)compressedBlockOffset);
            this.current = Slices.EMPTY_SLICE.getInput();
            discardedBuffer = true;
        } else {
            discardedBuffer = false;
        }
        if ((long)decompressedOffset != this.current.position()) {
            this.current.setPosition(0L);
            if (this.current.remaining() < (long)decompressedOffset) {
                decompressedOffset = (int)((long)decompressedOffset - this.current.remaining());
                this.advance();
            }
            this.current.setPosition((long)decompressedOffset);
        }
        return discardedBuffer;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.current == null || n <= 0L) {
            return -1L;
        }
        long result = this.current.skip(n);
        if (result != 0L) {
            return result;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.current.skip(n - 1L);
    }

    private void advance() throws IOException {
        if (this.compressedSliceInput == null || this.compressedSliceInput.remaining() == 0L) {
            this.current = null;
            return;
        }
        this.currentCompressedBlockOffset = Ints.checkedCast((long)this.compressedSliceInput.position());
        int b0 = this.compressedSliceInput.readUnsignedByte();
        int b1 = this.compressedSliceInput.readUnsignedByte();
        int b2 = this.compressedSliceInput.readUnsignedByte();
        boolean isUncompressed = (b0 & 1) == 1;
        int chunkLength = b2 << 15 | b1 << 7 | b0 >>> 1;
        if (chunkLength < 0 || (long)chunkLength > this.compressedSliceInput.remaining()) {
            throw new OrcCorruptionException(String.format("The chunkLength (%s) must not be negative or greater than remaining size (%s)", chunkLength, this.compressedSliceInput.remaining()));
        }
        Slice chunk = this.compressedSliceInput.readSlice(chunkLength);
        if (isUncompressed) {
            this.current = chunk.getInput();
        } else {
            int uncompressedSize = this.compressionKind == CompressionKind.ZLIB ? this.decompressZip(chunk) : this.decompressSnappy(chunk);
            this.current = Slices.wrappedBuffer((byte[])this.buffer, (int)0, (int)uncompressedSize).getInput();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("compressedOffset", this.compressedSliceInput.position()).add("uncompressedOffset", this.current == null ? null : Long.valueOf(this.current.position())).add("compression", (Object)this.compressionKind).toString();
    }

    private int decompressZip(Slice in) throws IOException {
        Inflater inflater = new Inflater(true);
        try {
            int uncompressedLength;
            block7: {
                int oldBufferSize;
                inflater.setInput((byte[])in.getBase(), (int)(in.getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), in.length());
                this.allocateOrGrowBuffer(in.length() * 5, false);
                uncompressedLength = 0;
                do {
                    uncompressedLength += inflater.inflate(this.buffer, uncompressedLength, this.buffer.length - uncompressedLength);
                    if (inflater.finished() || this.buffer.length >= this.maxBufferSize) break block7;
                    oldBufferSize = this.buffer.length;
                    this.allocateOrGrowBuffer(this.buffer.length * 2, true);
                } while (this.buffer.length > oldBufferSize);
                throw new IllegalStateException(String.format("Buffer failed to grow. Old size %d, current size %d", oldBufferSize, this.buffer.length));
            }
            if (!inflater.finished()) {
                throw new OrcCorruptionException("Could not decompress all input (output buffer too small?)");
            }
            int n = uncompressedLength;
            return n;
        }
        catch (DataFormatException e) {
            throw new OrcCorruptionException(e, "Invalid compressed stream", new Object[0]);
        }
        finally {
            inflater.end();
        }
    }

    private int decompressSnappy(Slice in) throws IOException {
        byte[] inArray = (byte[])in.getBase();
        int inOffset = (int)(in.getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
        int inLength = in.length();
        int uncompressedLength = Snappy.getUncompressedLength((byte[])inArray, (int)inOffset);
        Preconditions.checkArgument((uncompressedLength <= this.maxBufferSize ? 1 : 0) != 0, (String)"Snappy requires buffer (%s) larger than max size (%s)", (Object[])new Object[]{uncompressedLength, this.maxBufferSize});
        this.allocateOrGrowBuffer(uncompressedLength, false);
        return Snappy.uncompress((byte[])inArray, (int)inOffset, (int)inLength, (byte[])this.buffer, (int)0);
    }

    private void allocateOrGrowBuffer(int size, boolean copyExistingData) {
        if (this.buffer == null || this.buffer.length < size) {
            this.buffer = copyExistingData && this.buffer != null ? Arrays.copyOfRange(this.buffer, 0, Math.min(size, this.maxBufferSize)) : new byte[Math.min(size, this.maxBufferSize)];
        }
        this.bufferMemoryUsage.setBytes(this.buffer.length);
    }
}

