/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDecompressor;
import com.google.common.base.Preconditions;
import io.airlift.compress.snappy.SnappyDecompressor;

class OrcSnappyDecompressor
implements OrcDecompressor {
    private final int maxBufferSize;
    private final SnappyDecompressor decompressor = new SnappyDecompressor();

    public OrcSnappyDecompressor(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        int uncompressedLength = SnappyDecompressor.getUncompressedLength((byte[])input, (int)offset);
        Preconditions.checkArgument((uncompressedLength <= this.maxBufferSize ? 1 : 0) != 0, (String)"Snappy requires buffer (%s) larger than max size (%s)", (int)uncompressedLength, (int)this.maxBufferSize);
        byte[] buffer = output.initialize(uncompressedLength + 8);
        return this.decompressor.decompress(input, offset, length, buffer, 0, buffer.length);
    }

    public String toString() {
        return "snappy";
    }
}

