/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hive.common.util.BloomFilter;

public class TupleDomainOrcPredicate<C>
implements OrcPredicate {
    private final TupleDomain<C> effectivePredicate;
    private final List<ColumnReference<C>> columnReferences;
    private final boolean orcBloomFiltersEnabled;

    public TupleDomainOrcPredicate(TupleDomain<C> effectivePredicate, List<ColumnReference<C>> columnReferences, boolean orcBloomFiltersEnabled) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columnReferences = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnReferences, "columnReferences is null"));
        this.orcBloomFiltersEnabled = orcBloomFiltersEnabled;
    }

    @Override
    public boolean matches(long numberOfRows, Map<Integer, ColumnStatistics> statisticsByColumnIndex) {
        Optional optionalEffectivePredicateDomains = this.effectivePredicate.getDomains();
        if (!optionalEffectivePredicateDomains.isPresent()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)optionalEffectivePredicateDomains.get();
        for (ColumnReference<C> columnReference : this.columnReferences) {
            ColumnStatistics columnStatistics;
            Domain predicateDomain = (Domain)effectivePredicateDomains.get(columnReference.getColumn());
            if (predicateDomain == null || (columnStatistics = statisticsByColumnIndex.get(columnReference.getOrdinal())) == null || this.columnOverlaps(columnReference, predicateDomain, numberOfRows, columnStatistics)) continue;
            return false;
        }
        return true;
    }

    private boolean columnOverlaps(ColumnReference<C> columnReference, Domain predicateDomain, long numberOfRows, ColumnStatistics columnStatistics) {
        Domain stripeDomain = TupleDomainOrcPredicate.getDomain(columnReference.getType(), numberOfRows, columnStatistics);
        if (!stripeDomain.overlaps(predicateDomain)) {
            return false;
        }
        if (!this.orcBloomFiltersEnabled) {
            return true;
        }
        if (predicateDomain.isNullAllowed() && stripeDomain.isNullAllowed()) {
            return true;
        }
        Optional<Collection<Object>> discreteValues = TupleDomainOrcPredicate.extractDiscreteValues(predicateDomain.getValues());
        if (!discreteValues.isPresent()) {
            return true;
        }
        HiveBloomFilter bloomFilter = columnStatistics.getBloomFilter();
        if (bloomFilter == null) {
            return true;
        }
        return !discreteValues.get().stream().noneMatch(value -> TupleDomainOrcPredicate.checkInBloomFilter(bloomFilter, value, stripeDomain.getType()));
    }

    @VisibleForTesting
    public static Optional<Collection<Object>> extractDiscreteValues(ValueSet valueSet) {
        return (Optional)valueSet.getValuesProcessor().transform(ranges -> {
            ImmutableList.Builder discreteValues = ImmutableList.builder();
            for (Range range : ranges.getOrderedRanges()) {
                if (!range.isSingleValue()) {
                    return Optional.empty();
                }
                discreteValues.add(range.getSingleValue());
            }
            return Optional.of(discreteValues.build());
        }, discreteValues -> Optional.of(discreteValues.getValues()), allOrNone -> allOrNone.isAll() ? Optional.empty() : Optional.of(ImmutableList.of()));
    }

    @VisibleForTesting
    public static boolean checkInBloomFilter(BloomFilter bloomFilter, Object predicateValue, Type sqlType) {
        if (sqlType == TinyintType.TINYINT || sqlType == SmallintType.SMALLINT || sqlType == IntegerType.INTEGER || sqlType == BigintType.BIGINT) {
            return bloomFilter.testLong(((Number)predicateValue).longValue());
        }
        if (sqlType == DoubleType.DOUBLE) {
            return bloomFilter.testDouble(((Double)predicateValue).doubleValue());
        }
        if (sqlType instanceof VarcharType || sqlType instanceof VarbinaryType) {
            return bloomFilter.test(((Slice)predicateValue).getBytes());
        }
        return true;
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, ColumnStatistics columnStatistics) {
        boolean hasNullValue;
        if (rowCount == 0L) {
            return Domain.none((Type)type);
        }
        if (columnStatistics == null) {
            return Domain.all((Type)type);
        }
        if (columnStatistics.hasNumberOfValues() && columnStatistics.getNumberOfValues() == 0L) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = columnStatistics.getNumberOfValues() != rowCount;
        if (type.getJavaType() == Boolean.TYPE && columnStatistics.getBooleanStatistics() != null) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = columnStatistics.getBooleanStatistics();
            boolean hasTrueValues = booleanStatistics.getTrueValueCount() != 0L;
            boolean bl2 = hasFalseValues = columnStatistics.getNumberOfValues() != booleanStatistics.getTrueValueCount();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)BooleanType.BOOLEAN);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)BooleanType.BOOLEAN, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
        } else {
            if (Decimals.isShortDecimal((Type)type) && columnStatistics.getDecimalStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDecimalStatistics(), value -> Decimals.rescale((BigDecimal)value, (DecimalType)((DecimalType)type)).unscaledValue().longValue());
            }
            if (Decimals.isLongDecimal((Type)type) && columnStatistics.getDecimalStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDecimalStatistics(), value -> Decimals.encodeUnscaledValue((BigInteger)Decimals.rescale((BigDecimal)value, (DecimalType)((DecimalType)type)).unscaledValue()));
            }
            if (Chars.isCharType((Type)type) && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getStringStatistics(), value -> Chars.trimSpacesAndTruncateToLength((Slice)value, (Type)type));
            }
            if (Varchars.isVarcharType((Type)type) && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getStringStatistics());
            }
            if (type.getTypeSignature().getBase().equals("date") && columnStatistics.getDateStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDateStatistics(), value -> (long)value);
            }
            if (type.getJavaType() == Long.TYPE && columnStatistics.getIntegerStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getIntegerStatistics());
            }
            if (type.getJavaType() == Double.TYPE && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDoubleStatistics());
            }
            if (RealType.REAL.equals((Object)type) && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(type, hasNullValue, columnStatistics.getDoubleStatistics(), value -> Float.floatToRawIntBits(value.floatValue()));
            }
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<T> rangeStatistics) {
        return TupleDomainOrcPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, RangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, function.apply(min), (boolean)true, function.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, function.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, function.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    public static class ColumnReference<C> {
        private final C column;
        private final int ordinal;
        private final Type type;

        public ColumnReference(C column, int ordinal, Type type) {
            this.column = Objects.requireNonNull(column, "column is null");
            Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"ordinal is negative");
            this.ordinal = ordinal;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public C getColumn() {
            return this.column;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("ordinal", this.ordinal).add("type", (Object)this.type).toString();
        }
    }
}

