/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.checkpoint;

import com.facebook.presto.orc.checkpoint.Checkpoints;
import com.google.common.base.MoreObjects;

public final class InputStreamCheckpoint {
    private InputStreamCheckpoint() {
    }

    public static long createInputStreamCheckpoint(boolean compressed, Checkpoints.ColumnPositionsList positionsList) {
        if (!compressed) {
            return InputStreamCheckpoint.createInputStreamCheckpoint(0, positionsList.nextPosition());
        }
        return InputStreamCheckpoint.createInputStreamCheckpoint(positionsList.nextPosition(), positionsList.nextPosition());
    }

    public static long createInputStreamCheckpoint(int compressedBlockOffset, int decompressedOffset) {
        return (long)compressedBlockOffset << 32 | (long)decompressedOffset;
    }

    public static int decodeCompressedBlockOffset(long inputStreamCheckpoint) {
        return (int)(inputStreamCheckpoint >> 32);
    }

    public static int decodeDecompressedOffset(long inputStreamCheckpoint) {
        return (int)inputStreamCheckpoint;
    }

    public static String inputStreamCheckpointToString(long inputStreamCheckpoint) {
        return MoreObjects.toStringHelper(InputStreamCheckpoint.class).add("decompressedOffset", InputStreamCheckpoint.decodeDecompressedOffset(inputStreamCheckpoint)).add("compressedBlockOffset", InputStreamCheckpoint.decodeCompressedBlockOffset(inputStreamCheckpoint)).toString();
    }
}

