/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class MapStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final StreamReader keyStreamReader;
    private final StreamReader valueStreamReader;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    @Nonnull
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;

    public MapStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.keyStreamReader = StreamReaders.createStreamReader(streamDescriptor.getNestedStreams().get(0), hiveStorageTimeZone);
        this.valueStreamReader = StreamReaders.createStreamReader(streamDescriptor.getNestedStreams().get(1), hiveStorageTimeZone);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        Block values;
        Block keys;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                long entrySkipSize = this.lengthStream.sum(this.readOffset);
                this.keyStreamReader.prepareNextRead(Math.toIntExact(entrySkipSize));
                this.valueStreamReader.prepareNextRead(Math.toIntExact(entrySkipSize));
            }
        }
        int[] lengthVector = new int[this.nextBatchSize];
        boolean[] nullVector = new boolean[this.nextBatchSize];
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            this.lengthStream.nextIntVector(this.nextBatchSize, lengthVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                this.lengthStream.nextIntVector(this.nextBatchSize, lengthVector, nullVector);
            }
        }
        Type keyType = (Type)type.getTypeParameters().get(0);
        Type valueType = (Type)type.getTypeParameters().get(1);
        int entryCount = 0;
        for (int length : lengthVector) {
            entryCount += length;
        }
        if (entryCount > 0) {
            this.keyStreamReader.prepareNextRead(entryCount);
            this.valueStreamReader.prepareNextRead(entryCount);
            keys = this.keyStreamReader.readBlock(keyType);
            values = this.valueStreamReader.readBlock(valueType);
        } else {
            keys = keyType.createBlockBuilder(new BlockBuilderStatus(), 0).build();
            values = valueType.createBlockBuilder(new BlockBuilderStatus(), 1).build();
        }
        InterleavedBlock keyValueBlock = MapStreamReader.createKeyValueBlock(this.nextBatchSize, keys, values, lengthVector);
        int[] offsets = new int[this.nextBatchSize + 1];
        for (int i = 1; i < offsets.length; ++i) {
            int length = lengthVector[i - 1] * 2;
            offsets[i] = offsets[i - 1] + length;
        }
        ArrayBlock arrayBlock = new ArrayBlock(this.nextBatchSize, nullVector, offsets, (Block)keyValueBlock);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return arrayBlock;
    }

    private static InterleavedBlock createKeyValueBlock(int positionCount, Block keys, Block values, int[] lengths) {
        if (!MapStreamReader.hasNull(keys)) {
            return new InterleavedBlock(new Block[]{keys, values});
        }
        IntArrayList nonNullPositions = new IntArrayList(keys.getPositionCount());
        int position = 0;
        for (int mapIndex = 0; mapIndex < positionCount; ++mapIndex) {
            int length = lengths[mapIndex];
            for (int entryIndex = 0; entryIndex < length; ++entryIndex) {
                if (keys.isNull(position)) {
                    int n = mapIndex;
                    lengths[n] = lengths[n] - 1;
                } else {
                    nonNullPositions.add(position);
                }
                ++position;
            }
        }
        Block newKeys = keys.copyPositions((List)nonNullPositions);
        Block newValues = values.copyPositions((List)nonNullPositions);
        return new InterleavedBlock(new Block[]{newKeys, newValues});
    }

    private static boolean hasNull(Block keys) {
        for (int position = 0; position < keys.getPositionCount(); ++position) {
            if (!keys.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startStripe(dictionaryStreamSources, encoding);
        this.valueStreamReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startRowGroup(dataStreamSources);
        this.valueStreamReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

