/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthInputStream;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDictionaryStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean[] isNullVector = new boolean[0];
    @Nonnull
    private InputStreamSource<ByteArrayInputStream> stripeDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private boolean stripeDictionaryOpen;
    private int stripeDictionarySize;
    @Nonnull
    private Slice[] stripeDictionary = new Slice[1];
    private SliceArrayBlock dictionaryBlock = new SliceArrayBlock(this.stripeDictionary.length, this.stripeDictionary, true);
    @Nonnull
    private InputStreamSource<LongInputStream> stripeDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nonnull
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream inDictionaryStream;
    private boolean[] inDictionary = new boolean[0];
    @Nonnull
    private InputStreamSource<ByteArrayInputStream> rowGroupDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    @Nonnull
    private Slice[] rowGroupDictionary = new Slice[0];
    @Nonnull
    private InputStreamSource<RowGroupDictionaryLengthInputStream> rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(RowGroupDictionaryLengthInputStream.class);
    @Nonnull
    private int[] rowGroupDictionaryLength = new int[0];
    @Nonnull
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;

    public SliceDictionaryStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup(type);
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                if (this.inDictionaryStream != null) {
                    this.inDictionaryStream.skip(this.readOffset);
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.isNullVector.length < this.nextBatchSize) {
            this.isNullVector = new boolean[this.nextBatchSize];
        }
        int[] dataVector = new int[this.nextBatchSize];
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            Arrays.fill(this.isNullVector, false);
            this.dataStream.nextIntVector(this.nextBatchSize, dataVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.isNullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                this.dataStream.nextIntVector(this.nextBatchSize, dataVector, this.isNullVector);
            }
        }
        if (this.inDictionary.length < this.nextBatchSize) {
            this.inDictionary = new boolean[this.nextBatchSize];
        }
        if (this.inDictionaryStream == null) {
            Arrays.fill(this.inDictionary, true);
        } else {
            this.inDictionaryStream.getSetBits(this.nextBatchSize, this.inDictionary, this.isNullVector);
        }
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (this.isNullVector[i]) {
                dataVector[i] = this.dictionaryBlock.getPositionCount() - 1;
                continue;
            }
            if (this.inDictionary[i]) continue;
            int n = i;
            dataVector[n] = dataVector[n] + this.stripeDictionarySize;
        }
        DictionaryBlock block = new DictionaryBlock(this.nextBatchSize, (Block)this.dictionaryBlock, dataVector);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void setDictionaryBlockData(Slice[] dictionary) {
        if (this.dictionaryBlock.getValues() != dictionary) {
            this.dictionaryBlock = new SliceArrayBlock(dictionary.length, dictionary, true);
        }
    }

    private void openRowGroup(Type type) throws IOException {
        ByteArrayInputStream dictionaryDataStream;
        if (!this.stripeDictionaryOpen) {
            this.stripeDictionary = new Slice[this.stripeDictionarySize + 1];
            if (this.stripeDictionarySize > 0) {
                int[] dictionaryLength = new int[this.stripeDictionarySize];
                LongInputStream lengthStream = this.stripeDictionaryLengthStreamSource.openStream();
                if (lengthStream == null) {
                    throw new OrcCorruptionException("Dictionary is not empty but dictionary length stream is not present");
                }
                lengthStream.nextIntVector(this.stripeDictionarySize, dictionaryLength);
                dictionaryDataStream = this.stripeDictionaryDataStreamSource.openStream();
                SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, this.stripeDictionarySize, dictionaryLength, 0, this.stripeDictionary, type);
            }
        }
        this.stripeDictionaryOpen = true;
        RowGroupDictionaryLengthInputStream dictionaryLengthStream = this.rowGroupDictionaryLengthStreamSource.openStream();
        if (dictionaryLengthStream != null) {
            int rowGroupDictionarySize = dictionaryLengthStream.getEntryCount();
            this.rowGroupDictionary = Arrays.copyOf(this.stripeDictionary, this.stripeDictionarySize + rowGroupDictionarySize + 1);
            this.setDictionaryBlockData(this.rowGroupDictionary);
            if (this.rowGroupDictionaryLength.length < rowGroupDictionarySize) {
                this.rowGroupDictionaryLength = new int[rowGroupDictionarySize];
            }
            dictionaryLengthStream.nextIntVector(rowGroupDictionarySize, this.rowGroupDictionaryLength);
            dictionaryDataStream = this.rowGroupDictionaryDataStreamSource.openStream();
            SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, rowGroupDictionarySize, this.rowGroupDictionaryLength, this.stripeDictionarySize, this.rowGroupDictionary, type);
        } else {
            this.setDictionaryBlockData(this.stripeDictionary);
        }
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayInputStream dictionaryDataStream, int dictionarySize, int[] dictionaryLength, int dictionaryOutputOffset, Slice[] dictionary, Type type) throws IOException {
        for (int i = 0; i < dictionarySize; ++i) {
            int length = dictionaryLength[i];
            if (length == 0) {
                dictionary[dictionaryOutputOffset + i] = Slices.EMPTY_SLICE;
                continue;
            }
            Slice value = Slices.wrappedBuffer((byte[])dictionaryDataStream.next(length));
            if (Varchars.isVarcharType((Type)type)) {
                value = Varchars.truncateToLength((Slice)value, (Type)type);
            }
            if (Chars.isCharType((Type)type)) {
                value = Chars.trimSpacesAndTruncateToLength((Slice)value, (Type)type);
            }
            dictionary[dictionaryOutputOffset + i] = value;
        }
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.stripeDictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayInputStream.class);
        this.stripeDictionaryLengthStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.stripeDictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.stripeDictionaryOpen = false;
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(RowGroupDictionaryLengthInputStream.class);
        this.rowGroupDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanInputStream.class);
        this.rowGroupDictionaryLengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthInputStream.class);
        this.rowGroupDictionaryDataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

