/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.spi.ColumnIdentity;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Objects;

public final class RaptorColumnIdentity
implements ColumnIdentity {
    private static final byte CURRENT_VERSION = 1;
    private static final int SERIALIZED_SIZE = 9;
    private final long columnId;

    public RaptorColumnIdentity(long columnId) {
        this.columnId = columnId;
    }

    public static RaptorColumnIdentity deserialize(byte[] bytes) {
        Preconditions.checkArgument((bytes.length >= 1 ? 1 : 0) != 0, (Object)"bytes for RaptorColumnIdentity is corrupt");
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])bytes);
        byte version = input.readByte();
        if (version == 1 && bytes.length == 9) {
            long columnId = input.readLong();
            return new RaptorColumnIdentity(columnId);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CORRUPT_SERIALIZED_IDENTITY, "RaptorColumnIdentity is corrupt: " + BaseEncoding.base16().lowerCase().encode(bytes));
    }

    public byte[] serialize() {
        ByteArrayDataOutput output = ByteStreams.newDataOutput((int)9);
        output.write(1);
        output.writeLong(this.columnId);
        return output.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaptorColumnIdentity that = (RaptorColumnIdentity)o;
        return this.columnId == that.columnId;
    }

    public int hashCode() {
        return Objects.hash(this.columnId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnId", this.columnId).toString();
    }
}

