/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.ErrorType;

public enum RaptorErrorCode implements ErrorCodeSupplier
{
    RAPTOR_ERROR(0, ErrorType.EXTERNAL),
    RAPTOR_EXTERNAL_BATCH_ALREADY_EXISTS(1, ErrorType.EXTERNAL),
    RAPTOR_NO_HOST_FOR_SHARD(2, ErrorType.EXTERNAL),
    RAPTOR_RECOVERY_ERROR(3, ErrorType.EXTERNAL),
    RAPTOR_BACKUP_TIMEOUT(4, ErrorType.EXTERNAL),
    RAPTOR_METADATA_ERROR(5, ErrorType.EXTERNAL),
    RAPTOR_BACKUP_ERROR(6, ErrorType.EXTERNAL),
    RAPTOR_BACKUP_NOT_FOUND(7, ErrorType.EXTERNAL),
    RAPTOR_REASSIGNMENT_DELAY(8, ErrorType.EXTERNAL),
    RAPTOR_REASSIGNMENT_THROTTLE(9, ErrorType.EXTERNAL),
    RAPTOR_RECOVERY_TIMEOUT(10, ErrorType.EXTERNAL),
    RAPTOR_CORRUPT_METADATA(11, ErrorType.EXTERNAL),
    RAPTOR_LOCAL_DISK_FULL(12, ErrorType.EXTERNAL);

    private final ErrorCode errorCode;

    private RaptorErrorCode(int code, ErrorType type) {
        this.errorCode = new ErrorCode(code + 0x3000000, this.name(), type);
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

