/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorSplit;
import com.facebook.presto.raptor.storage.ReaderAttributes;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.util.ConcatPageSource;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RaptorPageSourceProvider
implements ConnectorPageSourceProvider {
    private final StorageManager storageManager;

    @Inject
    public RaptorPageSourceProvider(StorageManager storageManager) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns) {
        RaptorSplit raptorSplit = (RaptorSplit)split;
        OptionalInt bucketNumber = raptorSplit.getBucketNumber();
        TupleDomain<RaptorColumnHandle> predicate = raptorSplit.getEffectivePredicate();
        ReaderAttributes attributes = ReaderAttributes.from(session);
        OptionalLong transactionId = raptorSplit.getTransactionId();
        if (raptorSplit.getShardUuids().size() == 1) {
            UUID shardUuid2 = raptorSplit.getShardUuids().iterator().next();
            return this.createPageSource(shardUuid2, bucketNumber, columns, predicate, attributes, transactionId);
        }
        Iterator<ConnectorPageSource> iterator = raptorSplit.getShardUuids().stream().map(shardUuid -> this.createPageSource((UUID)shardUuid, bucketNumber, columns, predicate, attributes, transactionId)).iterator();
        return new ConcatPageSource(iterator);
    }

    private ConnectorPageSource createPageSource(UUID shardUuid, OptionalInt bucketNumber, List<ColumnHandle> columns, TupleDomain<RaptorColumnHandle> predicate, ReaderAttributes attributes, OptionalLong transactionId) {
        List columnHandles = columns.stream().map(RaptorColumnHandle.class::cast).collect(Collectors.toList());
        List<Long> columnIds = columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
        List<Type> columnTypes = columnHandles.stream().map(RaptorColumnHandle::getColumnType).collect(Collectors.toList());
        return this.storageManager.getPageSource(shardUuid, bucketNumber, columnIds, columnTypes, predicate, attributes, transactionId);
    }
}

