/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.raptor.PluginInfo;
import com.facebook.presto.raptor.RaptorConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public class RaptorPlugin
implements Plugin {
    private final String name;
    private final Module metadataModule;
    private final Map<String, Module> backupProviders;

    public RaptorPlugin() {
        this(RaptorPlugin.getPluginInfo());
    }

    private RaptorPlugin(PluginInfo info) {
        this(info.getName(), info.getMetadataModule(), info.getBackupProviders());
    }

    public RaptorPlugin(String name, Module metadataModule, Map<String, Module> backupProviders) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metadataModule = Objects.requireNonNull(metadataModule, "metadataModule is null");
        this.backupProviders = ImmutableMap.copyOf(Objects.requireNonNull(backupProviders, "backupProviders is null"));
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new RaptorConnectorFactory(this.name, this.metadataModule, this.backupProviders));
    }

    private static PluginInfo getPluginInfo() {
        ClassLoader classLoader = RaptorPlugin.class.getClassLoader();
        ServiceLoader<PluginInfo> loader = ServiceLoader.load(PluginInfo.class, classLoader);
        ImmutableList list = ImmutableList.copyOf(loader);
        return list.isEmpty() ? new PluginInfo() : (PluginInfo)Iterables.getOnlyElement((Iterable)list);
    }
}

