/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableIdentity;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Objects;

public final class RaptorTableIdentity
implements TableIdentity {
    private static final byte CURRENT_VERSION = 1;
    private static final int SERIALIZED_SIZE = 9;
    private final long tableId;

    public RaptorTableIdentity(long tableId) {
        Preconditions.checkArgument((tableId > 0L ? 1 : 0) != 0, (Object)"tableId must be greater than zero");
        this.tableId = tableId;
    }

    public static RaptorTableIdentity deserialize(byte[] bytes) {
        Preconditions.checkArgument((bytes.length >= 1 ? 1 : 0) != 0, (Object)"bytes for RaptorTableIdentity is corrupt");
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])bytes);
        byte version = input.readByte();
        if (version == 1 && bytes.length == 9) {
            long tableId = input.readLong();
            return new RaptorTableIdentity(tableId);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CORRUPT_SERIALIZED_IDENTITY, "RaptorTableIdentity is corrupt: " + BaseEncoding.base16().lowerCase().encode(bytes));
    }

    public byte[] serialize() {
        ByteArrayDataOutput output = ByteStreams.newDataOutput((int)9);
        output.write(1);
        output.writeLong(this.tableId);
        return output.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaptorTableIdentity that = (RaptorTableIdentity)o;
        return this.tableId == that.tableId;
    }

    public int hashCode() {
        return Objects.hash(this.tableId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).toString();
    }
}

